/*  -*- Mode:Java; tab-width:8 -*-
 * JRum.java --- Remote control of Un*x Mozilla in pure Java
 * version 0.1, with com.jcraft.jwax.* version 0.1
 *
 * Copyright (c) 1988  JCraft Inc. all rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting 
 * documentation. No representations are made about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 */

package com.jcraft.jrum;

import java.net.*;
import java.io.*;
import com.jcraft.jwax.*;

public class JRum {
  private Display d;
  private int XA_MOZILLA_VERSION;
  private int XA_MOZILLA_LOCK;
  private int XA_MOZILLA_COMMAND;
  private int XA_MOZILLA_RESPONSE;
  private int XA_MOZILLA_URL;
  private int mozilla=0;

  private boolean raise=true;
  private String display=null;

  public JRum(){ this("", 0); }
  public JRum(int win){ this("", win); }
  public JRum(String display){ this(display, 0);  }
  public JRum(String display, int win){
    this.display=display;
    d=new Display(display);
    init(win);
  }

  private boolean getLock() throws java.io.IOException{
    String lock="foo";
    boolean result=false;
    while(true){
      d.xGrabServer();
      ReplyGetProperty r=d.xGetProperty(false, mozilla,	XA_MOZILLA_LOCK,
					Atom.XA_STRING, 0, 100);
      if(r==null || r.type==0){
	d.xChangeProperty(Display.PropModeReplace, mozilla,
			  XA_MOZILLA_LOCK, Atom.XA_STRING,
			  8, lock.length(), lock.getBytes());
	result=true;
      }
      d.xUngrabServer();

      if(result)break;
//    while(true){
//      // wait for PropertyNotify about MOZILLA_LOCK
//    }
    }
    return result;
  }

  private boolean releaseLock() throws java.io.IOException{
    boolean result=false;
    ReplyGetProperty r=d.xGetProperty(true, mozilla, XA_MOZILLA_LOCK,
				      Atom.XA_STRING, 0, 100);
    if(r==null){ result=false; }
    else if(r.value.length==0){ result=false; }
    else{ result=(new String(r.value)).equals("foo"); }
    return result;
  }

  private boolean init_atoms(){
    try{
      ReplyInternAtom rr;
      rr=d.xInternAtom(false, "_MOZILLA_VERSION");
      if(rr!=null){ XA_MOZILLA_VERSION=rr.atom; }
      //else{System.err.println("rr is null");}
      rr=d.xInternAtom(false, "_MOZILLA_LOCK");
      if(rr!=null){ XA_MOZILLA_LOCK=rr.atom; }
      //else{System.err.println("rr is null");}
      rr=d.xInternAtom(false, "_MOZILLA_COMMAND");
      if(rr!=null){ XA_MOZILLA_COMMAND=rr.atom; }
      //else{System.err.println("rr is null");}
      rr=d.xInternAtom(false, "_MOZILLA_RESPONSE");
      if(rr!=null){ XA_MOZILLA_RESPONSE=rr.atom; }
      //else{System.err.println("rr is null");}
      rr=d.xInternAtom(false, "_MOZILLA_URL");
      if(rr!=null){ XA_MOZILLA_URL=rr.atom; }
      //else{System.err.println("rr is null");}
    }
    catch(Exception e){
      System.err.println(e);
      return false;
    }
    return true;
  }

  private boolean check_mozilla(int win){
    try{
      ReplyGetProperty rr=d.xGetProperty(false, win, XA_MOZILLA_VERSION,
					 Atom.XA_STRING, 0, 100);
      if(rr==null) return false;
      if(rr.value.length==0) return false;
      // version checking must be done, here!!

      d.xSelectInput(mozilla, 
		     (Event.PropertyChangeMask | 
		      Event.StructureNotifyMask));
    }
    catch(Exception e){
      System.err.println(e);
      return false;
    }
    return true;
  }

  private boolean find_mozilla(){
    try{
      int win;
      int tenative=0;
      ReplyQueryTree r = d.xQueryTree(d.defaultScreen().rootWindow());
      if(r==null) return false;
      for(int i=0; i<r.children.length; i++){
	win=d.xmuClientWindow(r.children[i]);
	ReplyGetProperty rr=d.xGetProperty(false, win, XA_MOZILLA_VERSION,
					   Atom.XA_STRING, 0, 100);
	if(rr==null || rr.value.length==0) continue;

	// version checking must be done, here!!

	mozilla=tenative=win;
	break;
      }
      if(mozilla==0){
	//System.err.println("mozilla is not found!!");
	return false;
      }

      d.xSelectInput(mozilla, 
		     (Event.PropertyChangeMask | Event.StructureNotifyMask));

    }
    catch(Exception e){
      System.err.println(e);
      return false;
    }
    return true;
  }

  private boolean init(int win){
    mozilla=win;
    return init();
  }

  private boolean init(){
    try{
      if(!init_atoms()) return false;
      if(mozilla==0){ find_mozilla(); }
      else{ if(!check_mozilla(mozilla)) mozilla=0; }
    }
    catch(Exception e){
      System.err.println(e);
      return false;
    }
    return true;
  }

  private String injectArg(String com, String arg){
    //  foo(a, b) --> foo(a, b, arg)
    byte[] foo=com.getBytes();
    boolean argzerop=true;
    int i=0;
    while(i<foo.length && foo[i]!='(')i++;
    if(foo.length!=i){ i++; }
    else{ return com+"("+arg+")"; }
    while(i<foo.length && foo[i]!=')'){
      if(foo[i]!=' ')argzerop=false;
      i++;
    }
    if(foo.length==i){
      System.out.println("??");
      return com;
    }
    return com.substring(0, i)+(argzerop ? "" : ", ")+arg+")";
  }

  public void setRaise(boolean b){ raise=b;}
  public void exec(String command) throws JRumException{
    if(mozilla==0){
      if(!find_mozilla()){ 
	throw new JRumException("mozilla is missing."); 
      }
    }
    if(!raise){ command=injectArg(command, "noraise");  }

    try{
//    getLock();
      d.xChangeProperty(Display.PropModeReplace, mozilla,
			XA_MOZILLA_COMMAND, Atom.XA_STRING,
			8, command.length(), command.getBytes());
      Event e;
      while(true){
	e=d.getEvent();
	if(e instanceof PropertyNotify){
	  PropertyNotify ee=(PropertyNotify)e;
	  if(ee.window==mozilla &&
	     ee.state==Display.PropertyNewValue &&
	     ee.atom==XA_MOZILLA_RESPONSE){
	    ReplyGetProperty rr=d.xGetProperty(false, mozilla, 
					       XA_MOZILLA_RESPONSE,
					       Atom.XA_STRING, 0, 100);
	    //System.out.println("response: "+new String(rr.value));
	    // respose shuld be checked!!
	    break;
	  }
	  else if(ee.window==mozilla &&
		  ee.state==Display.PropertyDelete &&
		  ee.atom==XA_MOZILLA_COMMAND){
	    ReplyGetProperty rr=d.xGetProperty(false, mozilla, 
					       XA_MOZILLA_COMMAND,
					       Atom.XA_STRING, 0, 100);
	    //System.out.println(command+" is accepted.");
	  }
	  else {
	    //System.out.println("atom="+ee.atom);
	  }
	}
	else if(e instanceof DestroyNotify){
	  DestroyNotify ee=(DestroyNotify)e;
	  if(ee.window==mozilla){
	    mozilla=0;
//	    d.close();
	    d=new Display(display);
	    throw new JRumException("mozilla is down.");
	  }
	}
      }
//    releaseLock();
    }
    catch(JRumException e){ throw e; }
    catch(Exception e){ 
//    System.err.println(e); 
      throw new JRumException(e.toString());
    }
  }

  public void openURLWithCUT_BUFFER(int buffer) throws JRumException { 
    try{
      byte[] bytes=d.xFetchBuffer(buffer); 
      if(bytes.length!=0){
	exec("openURL("+new String(bytes)+")"); 
      }
    }
    catch(Exception e){}
  }
  public void back() throws JRumException { exec("back()"); }
  public void forward() throws JRumException { exec("forward()"); }
  public void home() throws JRumException { exec("Home()"); }
  public void lineDown() throws JRumException { exec("LineDown()"); }
  public void lineUp() throws JRumException { exec("LineUp()"); }
  public void columnLeft() throws JRumException { exec("ColumnLeft"); }
  public void columnRight() throws JRumException { exec("ColumnRight"); }
  public void pageDown() throws JRumException { exec("PageDown()"); }
  public void pageUp() throws JRumException { exec("PageUp()"); }
  public void openURL() throws JRumException { exec("openURL()"); }
  public void openURL(String s) throws JRumException { 
    exec("openURL("+s+")"); 
  }
  public void openURLNewWindow(String s) throws JRumException { 
    exec("openURL("+s+",new-window)"); 
  }
  public void openFile() throws JRumException { exec("openFile()"); }
  public void openFile(String s) throws JRumException { 
    exec("openFile("+s+")"); 
  }
  public void saveAs() throws JRumException { exec("saveAs()"); }
  public void saveAs(String s) throws JRumException { exec("saveAs("+s+")"); }
  public void saveAsHtml(String s) throws JRumException { 
    exec("saveAs("+s+",HTML)"); 
  }
  public void saveAsText(String s) throws JRumException { 
    exec("saveAs("+s+",Text)"); 
  }
  public void saveAsPS(String s) throws JRumException { 
    exec("saveAs("+s+",PostScript)"); 
  }
  public void mailto() throws JRumException { exec("mailto()"); }
  public void mailto(String s) throws JRumException { 
    exec("mailto("+s+")"); 
  }
  public void openBookmarks() throws JRumException { 
    exec("xfeDoCommand(openBookmarks)"); 
  }
  public void addBookmark() throws JRumException { exec("addBookmark()"); }
  public void addBookmark(String s) throws JRumException { 
    exec("addBookmark("+s+")"); 
  }
  public void addBookmark(String s, String ss) throws JRumException { 
    exec("addBookmark("+s+","+ss+")"); 
  }
  public void fishcam() throws JRumException { exec("fishcam"); }
  public void netShowStatus() throws JRumException { exec("net_showstatus"); }
  public void openHistory() throws JRumException { exec("openHistory()"); }
  public void stopLoading() throws JRumException { exec("stopLoading()"); }
  public void viewPageSource() throws JRumException { 
    exec("viewPageSource()"); 
  }
  public void viewPageInfo() throws JRumException { exec("viewPageInfo()"); }
  public void pageServices() throws JRumException { exec("pageServices()"); }
  public void reload() throws JRumException { exec("reload()"); }
  public void showImages() throws JRumException { exec("showImages()"); }
  public void refresh() throws JRumException { exec("refresh()"); }
  public void openBrowser() throws JRumException { exec("openBrowser()"); }
  public void composeMessage() throws JRumException { 
    exec("composeMessage()"); 
  }
  public void newBlank() throws JRumException { exec("newBlank()"); }
  public void newTemplate() throws JRumException { exec("newTemplate()"); }
  public void newWizard() throws JRumException { exec("newWizard()"); }
  public void close() throws JRumException { exec("close()"); }

  public String getURL() throws JRumException {
    if(mozilla==0){
      if(!find_mozilla()){ throw new JRumException("mozilla is missing."); }
    }
    String result=null;
    try{
      ReplyGetProperty r=d.xGetProperty(false, mozilla, XA_MOZILLA_URL,	
					0, 0, 100);
      if(r!=null){ result=new String(r.value); }
    }
    catch(Exception e){ 
      System.err.println(e); 
      throw new JRumException(e.toString());
    }
    return result;
  }  
  public static void main(String[] arg){
    try{
      JRum jrum=new JRum();
      jrum.exec("openURL(http://www.jcraft.com/)");
    }
    catch(Exception e){ System.err.println(e); }
  }
}
