/*  -*- Mode:Java; tab-width:8 -*-
 * Sample1_1.java
 *
 * Copyright (c) 1988  JCraft Inc. all rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting 
 * documentation. No representations are made about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

import com.jcraft.jrum.*;

public class Sample1_1 extends Applet implements ActionListener, ItemListener {
  JRum jrum;
  String url;
  String[] urls={"http://www.netscape.com/",
		 "http://www.yahoo.com/",
		 "http://www.jcraft.com/",
		 "With CUT_BUFFER0"};

  boolean raise=true;

  public Sample1_1(String display) {
    setLayout(new FlowLayout(FlowLayout.LEFT));

    Panel p = new Panel();
    p.setLayout(new GridLayout(1, 10));
    add(p);

    Button b;
    b = new Button("Back"); b.addActionListener(this); p.add(b);
    b = new Button("Forward"); b.addActionListener(this); p.add(b);
    b = new Button("LineDown"); b.addActionListener(this); p.add(b);
    b = new Button("LineUp"); b.addActionListener(this); p.add(b);
    b = new Button("PageDown"); b.addActionListener(this); p.add(b);
    b = new Button("PageUp"); b.addActionListener(this); p.add(b);

    p = new Panel(); 
    p.setLayout(new FlowLayout());
    add(p);

    b = new Button("openURL"); b.addActionListener(this); p.add(b);

    Choice c;
    c = new Choice();
    for(int i=0; i<urls.length; i++){ c.addItem(urls[i]); }
    c.addItemListener(this);
    p.add(c);
    c = new Choice();
    c.addItem("raise");
    c.addItem("noraise");
    c.addItemListener(this);
    p.add(c);

    url=urls[0];

    jrum=new JRum(display);
    jrum.setRaise(raise);
  }
  public void itemStateChanged(ItemEvent e) {
    String item=(String)(e.getItem());
    if ("raise".equals(item)){ raise=true; jrum.setRaise(raise);}
    else if ("noraise".equals(item)) { raise=false; jrum.setRaise(raise);}
    else{ url=item; }
  }
  public void actionPerformed(ActionEvent e) {
    String arg = e.getActionCommand();
    try{
      if ("Back".equals(arg))         { jrum.back(); } 
      else if ("Forward".equals(arg)) { jrum.forward();} 
      else if ("LineDown".equals(arg)){ jrum.lineDown();} 
      else if ("LineUp".equals(arg))  { jrum.lineUp(); }
      else if ("PageDown".equals(arg)){ jrum.pageDown();} 
      else if ("PageUp".equals(arg))  { jrum.pageUp(); }
      else if ("openURL".equals(arg)) { 
	if(url.equals(urls[urls.length-1])){ jrum.openURLWithCUT_BUFFER(0); }
	else{ jrum.openURL(url); }
      } 
      else { System.out.println(e); }
    }
    catch(Exception ee){
      System.err.println(ee);
    }
  }
  public static void main(String args[]) {
    String display="";
    if(args.length==2 && args[0].equals("-d")){
      display=args[1];
    }
    Frame f = new Frame("Sample1_1");
    Sample1_1 dialog = new Sample1_1(display);
    dialog.init();
    dialog.start();

    f.add("Center", dialog);
    f.setSize(500, 100);
    f.show();
  }
}
