/*  -*- Mode:Java; tab-width:8 -*-
 * Sample.java
 *
 * Copyright (c) 1988  JCraft Inc. all rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting 
 * documentation. No representations are made about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

import com.jcraft.jrum.*;

public class Sample extends Applet {
  JRum jrum;
  String url;
  String[] urls={"http://www.netscape.com/",
		 "http://www.yahoo.com/",
		 "http://www.jcraft.com/",
		 "With CUT_BUFFER0"};

  boolean raise=true;

  public Sample(String display) {
    Button b;
    Panel p;

    setLayout(new FlowLayout(FlowLayout.LEFT));

    p= new Panel(); p.setLayout(new GridLayout(1, 10)); add(p);
    b = new Button("Back");     p.add(b);
    b = new Button("Forward");  p.add(b);
    b = new Button("LineDown"); p.add(b);
    b = new Button("LineUp");   p.add(b);
    b = new Button("PageDown"); p.add(b);
    b = new Button("PageUp");   p.add(b);

    p = new Panel();  p.setLayout(new FlowLayout()); add(p);
    b = new Button("OpenURL");  p.add(b);
    Choice c;
    c = new Choice();
    for(int i=0; i<urls.length; i++){ c.addItem(urls[i]); }
    p.add(c);
    c = new Choice();
    c.addItem("raise");
    c.addItem("noraise");
    p.add(c);

    url=urls[0];
    jrum=new JRum(display);
    jrum.setRaise(raise);
  }

  public boolean action(java.awt.Event evt, Object arg) {
    try{
      if (evt.target instanceof Choice) { 
	if ("raise".equals(arg)) { raise=true; jrum.setRaise(raise);}
	else if ("noraise".equals(arg)) { raise=false; jrum.setRaise(raise);}
	else{ url=(String)arg;}
      } 
      else if ("Back".equals(arg)) { jrum.back(); } 
      else if ("Forward".equals(arg)) { jrum.forward(); }
      else if ("LineDown".equals(arg)) { jrum.lineDown(); } 
      else if ("LineUp".equals(arg)) { jrum.lineUp(); } 
      else if ("PageDown".equals(arg)) { jrum.pageDown(); }
      else if ("PageUp".equals(arg)) { jrum.pageUp(); }
      else if ("OpenURL".equals(arg)) { 
	if(url.equals(urls[urls.length-1])){ jrum.openURLWithCUT_BUFFER(0); }
	else{ jrum.openURL(url); }
      }
      else { System.err.println(evt); }
    }
    catch(Exception ee){
      System.err.println(ee);
    }
    return true;
  }

  public static void main(String args[]) {
    String display="";
    if(args.length==2 && args[0].equals("-d")){
      display=args[1];
    }

    Frame f = new Frame("Sample");
    Sample dialog = new Sample(display);
    dialog.init();
    dialog.start();

    f.add("Center", dialog);
    f.setSize(500, 100);
    f.show();
  }
}
