/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jrum;

import com.jcraft.jrum.JRumException;
import com.jcraft.jwax.DestroyNotify;
import com.jcraft.jwax.Display;
import com.jcraft.jwax.Event;
import com.jcraft.jwax.PropertyNotify;
import com.jcraft.jwax.ReplyGetProperty;
import com.jcraft.jwax.ReplyInternAtom;
import com.jcraft.jwax.ReplyQueryTree;
import java.io.IOException;

public class JRum {
    private Display d;
    private int XA_MOZILLA_VERSION;
    private int XA_MOZILLA_LOCK;
    private int XA_MOZILLA_COMMAND;
    private int XA_MOZILLA_RESPONSE;
    private int XA_MOZILLA_URL;
    private int mozilla;
    private boolean raise = true;
    private String display;

    public JRum() {
        this("", 0);
    }

    public JRum(int n) {
        this("", n);
    }

    public JRum(String string) {
        this(string, 0);
    }

    public JRum(String string, int n) {
        this.display = string;
        this.d = new Display(string);
        this.mozilla = n;
        this.init();
    }

    private boolean getLock() throws IOException {
        boolean bl = false;
        do {
            this.d.xGrabServer();
            ReplyGetProperty replyGetProperty = this.d.xGetProperty(false, this.mozilla, this.XA_MOZILLA_LOCK, 31, 0, 100);
            if (replyGetProperty == null || replyGetProperty.type == 0) {
                this.d.xChangeProperty(0, this.mozilla, this.XA_MOZILLA_LOCK, 31, 8, "foo".length(), "foo".getBytes());
                bl = true;
            }
            this.d.xUngrabServer();
        } while (!bl);
        return bl;
    }

    private boolean releaseLock() throws IOException {
        boolean bl = false;
        ReplyGetProperty replyGetProperty = this.d.xGetProperty(true, this.mozilla, this.XA_MOZILLA_LOCK, 31, 0, 100);
        bl = replyGetProperty == null ? false : (replyGetProperty.value.length == 0 ? false : new String(replyGetProperty.value).equals("foo"));
        return bl;
    }

    private boolean init_atoms() {
        try {
            ReplyInternAtom replyInternAtom = this.d.xInternAtom(false, "_MOZILLA_VERSION");
            if (replyInternAtom != null) {
                this.XA_MOZILLA_VERSION = replyInternAtom.atom;
            }
            if ((replyInternAtom = this.d.xInternAtom(false, "_MOZILLA_LOCK")) != null) {
                this.XA_MOZILLA_LOCK = replyInternAtom.atom;
            }
            if ((replyInternAtom = this.d.xInternAtom(false, "_MOZILLA_COMMAND")) != null) {
                this.XA_MOZILLA_COMMAND = replyInternAtom.atom;
            }
            if ((replyInternAtom = this.d.xInternAtom(false, "_MOZILLA_RESPONSE")) != null) {
                this.XA_MOZILLA_RESPONSE = replyInternAtom.atom;
            }
            if ((replyInternAtom = this.d.xInternAtom(false, "_MOZILLA_URL")) != null) {
                this.XA_MOZILLA_URL = replyInternAtom.atom;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
        return true;
    }

    private boolean check_mozilla(int n) {
        try {
            ReplyGetProperty replyGetProperty = this.d.xGetProperty(false, n, this.XA_MOZILLA_VERSION, 31, 0, 100);
            if (replyGetProperty == null) {
                return false;
            }
            if (replyGetProperty.value.length == 0) {
                return false;
            }
            this.d.xSelectInput(this.mozilla, 0x420000);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
        return true;
    }

    private boolean find_mozilla() {
        try {
            int n = 0;
            ReplyQueryTree replyQueryTree = this.d.xQueryTree(this.d.defaultScreen().rootWindow());
            if (replyQueryTree == null) {
                return false;
            }
            int n2 = 0;
            while (n2 < replyQueryTree.children.length) {
                int n3 = this.d.xmuClientWindow(replyQueryTree.children[n2]);
                ReplyGetProperty replyGetProperty = this.d.xGetProperty(false, n3, this.XA_MOZILLA_VERSION, 31, 0, 100);
                if (replyGetProperty != null && replyGetProperty.value.length != 0) {
                    this.mozilla = n = n3;
                    break;
                }
                ++n2;
            }
            if (this.mozilla == 0) {
                return false;
            }
            this.d.xSelectInput(this.mozilla, 0x420000);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
        return true;
    }

    private boolean init(int n) {
        this.mozilla = n;
        return this.init();
    }

    private boolean init() {
        try {
            if (!this.init_atoms()) {
                return false;
            }
            if (this.mozilla == 0) {
                this.find_mozilla();
            } else if (!this.check_mozilla(this.mozilla)) {
                this.mozilla = 0;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String injectArg(String string, String string2) {
        String string3;
        byte[] byArray = string.getBytes();
        boolean bl = true;
        int n = 0;
        while (n < byArray.length && byArray[n] != 40) {
            ++n;
        }
        if (byArray.length == n) return String.valueOf(string) + "(" + string2 + ")";
        ++n;
        while (n < byArray.length && byArray[n] != 41) {
            if (byArray[n] != 32) {
                bl = false;
            }
            ++n;
        }
        if (byArray.length == n) {
            System.out.println("??");
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(string.substring(0, n)));
        if (bl) {
            string3 = "";
            return stringBuffer.append(string3).append(string2).append(")").toString();
        }
        string3 = ", ";
        return stringBuffer.append(string3).append(string2).append(")").toString();
    }

    public void setRaise(boolean bl) {
        this.raise = bl;
    }

    public void exec(String string) throws JRumException {
        if (this.mozilla == 0 && !this.find_mozilla()) {
            throw new JRumException("mozilla is missing.");
        }
        if (!this.raise) {
            string = this.injectArg(string, "noraise");
        }
        try {
            this.d.xChangeProperty(0, this.mozilla, this.XA_MOZILLA_COMMAND, 31, 8, string.length(), string.getBytes());
            while (true) {
                PropertyNotify propertyNotify;
                Event event;
                if ((event = this.d.getEvent()) instanceof PropertyNotify) {
                    propertyNotify = (PropertyNotify)event;
                    if (propertyNotify.window == this.mozilla && propertyNotify.state == 0 && propertyNotify.atom == this.XA_MOZILLA_RESPONSE) {
                        this.d.xGetProperty(false, this.mozilla, this.XA_MOZILLA_RESPONSE, 31, 0, 100);
                        return;
                    }
                    if (propertyNotify.window != this.mozilla || propertyNotify.state != 1 || propertyNotify.atom != this.XA_MOZILLA_COMMAND) continue;
                    this.d.xGetProperty(false, this.mozilla, this.XA_MOZILLA_COMMAND, 31, 0, 100);
                    continue;
                }
                if (!(event instanceof DestroyNotify)) continue;
                propertyNotify = (DestroyNotify)event;
                if (propertyNotify.window == this.mozilla) break;
            }
            this.mozilla = 0;
            this.d = new Display(this.display);
            throw new JRumException("mozilla is down.");
        }
        catch (JRumException jRumException) {
            throw jRumException;
        }
        catch (Exception exception) {
            throw new JRumException(exception.toString());
        }
    }

    public void openURLWithCUT_BUFFER(int n) throws JRumException {
        try {
            byte[] byArray = this.d.xFetchBuffer(n);
            if (byArray.length != 0) {
                this.exec("openURL(" + new String(byArray) + ")");
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void back() throws JRumException {
        this.exec("back()");
    }

    public void forward() throws JRumException {
        this.exec("forward()");
    }

    public void home() throws JRumException {
        this.exec("Home()");
    }

    public void lineDown() throws JRumException {
        this.exec("LineDown()");
    }

    public void lineUp() throws JRumException {
        this.exec("LineUp()");
    }

    public void columnLeft() throws JRumException {
        this.exec("ColumnLeft");
    }

    public void columnRight() throws JRumException {
        this.exec("ColumnRight");
    }

    public void pageDown() throws JRumException {
        this.exec("PageDown()");
    }

    public void pageUp() throws JRumException {
        this.exec("PageUp()");
    }

    public void openURL() throws JRumException {
        this.exec("openURL()");
    }

    public void openURL(String string) throws JRumException {
        this.exec("openURL(" + string + ")");
    }

    public void openURLNewWindow(String string) throws JRumException {
        this.exec("openURL(" + string + ",new-window)");
    }

    public void openFile() throws JRumException {
        this.exec("openFile()");
    }

    public void openFile(String string) throws JRumException {
        this.exec("openFile(" + string + ")");
    }

    public void saveAs() throws JRumException {
        this.exec("saveAs()");
    }

    public void saveAs(String string) throws JRumException {
        this.exec("saveAs(" + string + ")");
    }

    public void saveAsHtml(String string) throws JRumException {
        this.exec("saveAs(" + string + ",HTML)");
    }

    public void saveAsText(String string) throws JRumException {
        this.exec("saveAs(" + string + ",Text)");
    }

    public void saveAsPS(String string) throws JRumException {
        this.exec("saveAs(" + string + ",PostScript)");
    }

    public void mailto() throws JRumException {
        this.exec("mailto()");
    }

    public void mailto(String string) throws JRumException {
        this.exec("mailto(" + string + ")");
    }

    public void openBookmarks() throws JRumException {
        this.exec("xfeDoCommand(openBookmarks)");
    }

    public void addBookmark() throws JRumException {
        this.exec("addBookmark()");
    }

    public void addBookmark(String string) throws JRumException {
        this.exec("addBookmark(" + string + ")");
    }

    public void addBookmark(String string, String string2) throws JRumException {
        this.exec("addBookmark(" + string + "," + string2 + ")");
    }

    public void fishcam() throws JRumException {
        this.exec("fishcam");
    }

    public void netShowStatus() throws JRumException {
        this.exec("net_showstatus");
    }

    public void openHistory() throws JRumException {
        this.exec("openHistory()");
    }

    public void stopLoading() throws JRumException {
        this.exec("stopLoading()");
    }

    public void viewPageSource() throws JRumException {
        this.exec("viewPageSource()");
    }

    public void viewPageInfo() throws JRumException {
        this.exec("viewPageInfo()");
    }

    public void pageServices() throws JRumException {
        this.exec("pageServices()");
    }

    public void reload() throws JRumException {
        this.exec("reload()");
    }

    public void showImages() throws JRumException {
        this.exec("showImages()");
    }

    public void refresh() throws JRumException {
        this.exec("refresh()");
    }

    public void openBrowser() throws JRumException {
        this.exec("openBrowser()");
    }

    public void composeMessage() throws JRumException {
        this.exec("composeMessage()");
    }

    public void newBlank() throws JRumException {
        this.exec("newBlank()");
    }

    public void newTemplate() throws JRumException {
        this.exec("newTemplate()");
    }

    public void newWizard() throws JRumException {
        this.exec("newWizard()");
    }

    public void close() throws JRumException {
        this.exec("close()");
    }

    public String getURL() throws JRumException {
        if (this.mozilla == 0 && !this.find_mozilla()) {
            throw new JRumException("mozilla is missing.");
        }
        String string = null;
        try {
            ReplyGetProperty replyGetProperty = this.d.xGetProperty(false, this.mozilla, this.XA_MOZILLA_URL, 0, 0, 100);
            if (replyGetProperty != null) {
                string = new String(replyGetProperty.value);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            throw new JRumException(exception.toString());
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            JRum jRum = new JRum();
            jRum.exec("openURL(http://www.jcraft.com/)");
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }
}

