/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jwax;

import com.jcraft.jwax.Depth;
import com.jcraft.jwax.IO;
import java.io.IOException;
import java.io.PrintStream;

class Screen {
    int rootid;
    int colormap;
    int wpixel;
    int bpixel;
    int cimask;
    int wipixel;
    int hipixel;
    int wimili;
    int himili;
    int minmaps;
    int maxmaps;
    int rvisual;
    int bstore;
    int sunder;
    int rdepth;
    Depth[] depth;

    static Screen parse(IO iO) throws IOException {
        Screen screen = new Screen();
        screen.rootid = iO.getInt();
        screen.colormap = iO.getInt();
        screen.wpixel = iO.getInt();
        screen.bpixel = iO.getInt();
        screen.cimask = iO.getInt();
        screen.wipixel = iO.getShort();
        screen.hipixel = iO.getShort();
        screen.wimili = iO.getShort();
        screen.himili = iO.getShort();
        screen.minmaps = iO.getShort();
        screen.maxmaps = iO.getShort();
        screen.rvisual = iO.getInt();
        screen.bstore = iO.getByte();
        screen.sunder = iO.getByte();
        screen.rdepth = iO.getByte();
        int n = iO.getByte();
        screen.depth = new Depth[n];
        int n2 = 0;
        while (n2 < screen.depth.length) {
            screen.depth[n2] = Depth.parse(iO);
            ++n2;
        }
        return screen;
    }

    public int rootWindow() {
        return this.rootid;
    }

    void print(PrintStream printStream) {
        printStream.println("SCREEN:");
        printStream.println("  root = " + this.rootid);
        printStream.println("  defaultColormap = " + this.colormap);
        printStream.println("  white = " + this.wpixel);
        printStream.println("  black = " + this.bpixel);
        printStream.println("  currentInputMasks = " + Integer.toHexString(this.cimask));
        printStream.println("  width = " + this.wipixel);
        printStream.println("  height = " + this.hipixel);
        printStream.println("  width_mm = " + this.wimili);
        printStream.println("  height_mm = " + this.himili);
        printStream.println("  minInstalledMaps = " + this.minmaps);
        printStream.println("  maxInstalledMaps = " + this.maxmaps);
        printStream.println("  root-visual = " + this.rvisual);
        printStream.println("  backingStores = " + this.bstore);
        printStream.println("  saveUnders = " + this.sunder);
        printStream.println("  root-depth = " + this.rdepth);
        printStream.println("  depth.length = " + this.depth.length);
        int n = 0;
        while (n < this.depth.length) {
            this.depth[n].print(printStream);
            ++n;
        }
    }

    Screen() {
    }
}

