/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jwax;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class IO {
    boolean push = false;
    int bag;
    InputStream in;
    OutputStream out;
    byte[] inbuffer = new byte[1024];
    byte[] outbuffer = new byte[1024];
    int instart;
    int inend;
    int outindex;
    int inrest;

    IO() {
    }

    IO(InputStream inputStream, OutputStream outputStream) {
        this();
        this.in = inputStream;
        this.out = outputStream;
    }

    IO(InputStream inputStream) {
        this();
        this.in = inputStream;
    }

    IO(OutputStream outputStream) {
        this();
        this.out = outputStream;
    }

    int available() throws IOException {
        if (this.push) {
            return 1;
        }
        if (this.inrest > 0) {
            return 1;
        }
        return this.in.available();
    }

    void push(int n) {
        if (this.push) {
            System.out.println("over flow!!");
            return;
        }
        this.push = true;
        this.bag = n;
    }

    int getByte() throws IOException {
        if (this.push) {
            this.push = false;
            return this.bag;
        }
        if (this.inrest < 1) {
            this.read(1);
        }
        --this.inrest;
        return this.inbuffer[this.instart++] & 0xFF;
    }

    void getByte(byte[] byArray) throws IOException {
        this.getByte(byArray, 0, byArray.length);
    }

    void getByte(byte[] byArray, int n, int n2) throws IOException {
        if (this.push) {
            this.push = false;
            byArray[n++] = (byte)this.bag;
            --n2;
        }
        int n3 = 0;
        while ((n3 = this.inrest) < n2) {
            if (n3 != 0) {
                System.arraycopy(this.inbuffer, this.instart, byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.instart += n3;
                this.inrest -= n3;
            }
            this.read(n2);
        }
        System.arraycopy(this.inbuffer, this.instart, byArray, n, n2);
        this.instart += n2;
        this.inrest -= n2;
    }

    int getShort() throws IOException {
        if (this.inrest < 2) {
            this.read(2);
        }
        int n = 0;
        if (this.push) {
            this.push = false;
            n = this.bag & 0xFF;
        } else {
            --this.inrest;
            n = this.inbuffer[this.instart++] & 0xFF;
        }
        --this.inrest;
        n = n << 8 & 0xFFFF | this.inbuffer[this.instart++] & 0xFF;
        return n;
    }

    int getInt() throws IOException {
        if (this.inrest < 4) {
            this.read(4);
        }
        int n = 0;
        if (this.push) {
            this.push = false;
            n = this.bag & 0xFF;
        } else {
            --this.inrest;
            n = this.inbuffer[this.instart++] & 0xFF;
        }
        this.inrest -= 3;
        n = n << 8 & 0xFFFF | this.inbuffer[this.instart++] & 0xFF;
        n = n << 8 & 0xFFFFFF | this.inbuffer[this.instart++] & 0xFF;
        n = n << 8 | this.inbuffer[this.instart++] & 0xFF;
        return n;
    }

    void getPad(int n) throws IOException {
        while (n > 0) {
            if (this.inrest < n) {
                this.instart += this.inrest;
                this.inrest = 0;
                this.read(n -= this.inrest);
                continue;
            }
            this.instart += n;
            this.inrest -= n;
            return;
        }
    }

    private final void read(int n) throws IOException {
        if (this.push) {
            --n;
        }
        if (n > this.inbuffer.length) {
            n = this.inbuffer.length;
        }
        this.inend = 0;
        this.instart = 0;
        do {
            int n2;
            if ((n2 = this.in.read(this.inbuffer, this.inend, this.inbuffer.length - this.inend)) == -1) {
                throw new IOException();
            }
            this.inend += n2;
        } while (n > this.inend);
        this.inrest = this.inend - this.instart;
    }

    void putByte(byte by) throws IOException {
        if (this.outbuffer.length - this.outindex < 1) {
            this.flush();
        }
        this.outbuffer[this.outindex++] = by;
    }

    void putByte(int n) throws IOException {
        this.putByte((byte)n);
    }

    void putByte(byte[] byArray) throws IOException {
        this.putByte(byArray, 0, byArray.length);
    }

    void putByte(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        while ((n3 = this.outbuffer.length - this.outindex) < n2) {
            if (n3 != 0) {
                System.arraycopy(byArray, n, this.outbuffer, this.outindex, n3);
                n += n3;
                n2 -= n3;
                this.outindex += n3;
            }
            this.flush();
        }
        System.arraycopy(byArray, n, this.outbuffer, this.outindex, n2);
        this.outindex += n2;
    }

    void putShort(int n) throws IOException {
        if (this.outbuffer.length - this.outindex < 2) {
            this.flush();
        }
        this.outbuffer[this.outindex++] = (byte)(n >> 8 & 0xFF);
        this.outbuffer[this.outindex++] = (byte)(n & 0xFF);
    }

    void putInt(int n) throws IOException {
        if (this.outbuffer.length - this.outindex < 4) {
            this.flush();
        }
        this.outbuffer[this.outindex++] = (byte)(n >> 24 & 0xFF);
        this.outbuffer[this.outindex++] = (byte)(n >> 16 & 0xFF);
        this.outbuffer[this.outindex++] = (byte)(n >> 8 & 0xFF);
        this.outbuffer[this.outindex++] = (byte)(n & 0xFF);
    }

    void putPad(int n) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        while ((n2 = this.outbuffer.length - this.outindex) < n) {
            if (n2 != 0) {
                this.outindex += n2;
                n -= n2;
            }
            this.flush();
        }
        this.outindex += n;
    }

    synchronized void flush() throws IOException {
        if (this.outindex == 0) {
            return;
        }
        this.out.write(this.outbuffer, 0, this.outindex);
        this.outindex = 0;
    }

    synchronized void immediateWrite(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    void close() throws IOException {
        this.in.close();
        this.out.close();
    }
}

