/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jwax;

import com.jcraft.jwax.ConfigureNotify;
import com.jcraft.jwax.DestroyNotify;
import com.jcraft.jwax.Display;
import com.jcraft.jwax.ErrorNotify;
import com.jcraft.jwax.PropertyNotify;
import com.jcraft.jwax.SelectionNotify;
import java.io.IOException;

public class Event {
    public static final int KeyPress = 2;
    public static final int KeyRelease = 3;
    public static final int ButtonPress = 4;
    public static final int ButtonRelease = 5;
    public static final int MotionNotify = 6;
    public static final int EnterNotify = 7;
    public static final int LeaveNotify = 8;
    public static final int FocusIn = 9;
    public static final int FocusOut = 10;
    public static final int KeymapNotify = 11;
    public static final int Expose = 12;
    public static final int GraphicsExpose = 13;
    public static final int NoExpose = 14;
    public static final int VisibilityNotify = 15;
    public static final int CreateNotify = 16;
    public static final int DestroyNotify = 17;
    public static final int UnmapNotify = 18;
    public static final int MapNotify = 19;
    public static final int MapRequest = 20;
    public static final int ReparentNotify = 21;
    public static final int ConfigureNotify = 22;
    public static final int ConfigureRequest = 23;
    public static final int GravityNotify = 24;
    public static final int ResizeRequest = 25;
    public static final int CirculateNotify = 26;
    public static final int CirculateRequest = 27;
    public static final int PropertyNotify = 28;
    public static final int SelectionClear = 29;
    public static final int SelectionRequest = 30;
    public static final int SelectionNotify = 31;
    public static final int ColormapNotify = 32;
    public static final int ClientMessage = 33;
    public static final int MappingNotify = 34;
    public static final int LASTEvent = 35;
    public static final int NoEventMask = 0;
    public static final int KeyPressMask = 1;
    public static final int KeyReleaseMask = 2;
    public static final int ButtonPressMask = 4;
    public static final int ButtonReleaseMask = 8;
    public static final int EnterWindowMask = 16;
    public static final int LeaveWindowMask = 32;
    public static final int PointerMotionMask = 64;
    public static final int PointerMotionHintMask = 128;
    public static final int Button1MotionMask = 256;
    public static final int Button2MotionMask = 512;
    public static final int Button3MotionMask = 1024;
    public static final int Button4MotionMask = 2048;
    public static final int Button5MotionMask = 4096;
    public static final int ButtonMotionMask = 8192;
    public static final int KeymapStateMask = 16384;
    public static final int ExposureMask = 32768;
    public static final int VisibilityChangeMask = 65536;
    public static final int StructureNotifyMask = 131072;
    public static final int ResizeRedirectMask = 262144;
    public static final int SubstructureNotifyMask = 524288;
    public static final int SubstructureRedirectMask = 0x100000;
    public static final int FocusChangeMask = 0x200000;
    public static final int PropertyChangeMask = 0x400000;
    public static final int ColormapChangeMask = 0x800000;
    public static final int OwnerGrabButtonMask = 0x1000000;
    public static final int Button1Mask = 256;
    public static final int Button2Mask = 512;
    public static final int Button3Mask = 1024;
    public static final int Button4Mask = 2048;
    public static final int Button5Mask = 4096;
    public static final int NoSuchEvent = Integer.MIN_VALUE;
    public static final int StructureAndSubMask = 655360;
    public static final int CantBeFiltered = 0;
    static final int[] filters = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, 1, 2, 4, 8, 64, 16, 32, 0x200000, 0x200000, 16384, 32768, 0, 0, 65536, 524288, 655360, 655360, 655360, 0x100000, 655360, 655360, 0x100000, 655360, 262144, 655360, 0x100000, 0x400000, 0, 0, 0, 0x800000, 0, 0};
    public static final int AtMostOneClient = 0x140004;
    public static final int MotionMask = 16192;
    public static final int PropagateMask = 16207;
    public static final int PointerGrabMask = 32764;
    static final int EXTENSION_EVENT_BASE = 64;
    byte[] event;
    int index;
    static final byte[] zeros = new byte[32];
    public int type;
    public int code;
    public int seq;

    public String toString() {
        return "Event: type=" + this.type + ", type&0177=" + (this.type & 0x7F) + ", code=" + this.code + ", seq=" + this.seq;
    }

    Event(byte[] byArray) {
        this.event = byArray;
        this.init();
    }

    Event() {
        this.event = new byte[32];
        this.init();
    }

    void clear() {
        System.arraycopy(zeros, 0, this.event, 0, 32);
        this.index = 0;
    }

    void putByte(byte by) {
        this.event[this.index++] = by;
    }

    void putShort(int n) {
        this.event[this.index++] = (byte)(n >> 8 & 0xFF);
        this.event[this.index++] = (byte)(n & 0xFF);
    }

    void putInt(int n) {
        this.event[this.index++] = (byte)(n >> 24 & 0xFF);
        this.event[this.index++] = (byte)(n >> 16 & 0xFF);
        this.event[this.index++] = (byte)(n >> 8 & 0xFF);
        this.event[this.index++] = (byte)(n & 0xFF);
    }

    void putPad(int n) {
        this.index += n;
    }

    void _clear() {
        System.arraycopy(zeros, 0, this.event, 0, 32);
        this.index = 0;
    }

    private void _putByte(byte by) {
        this.event[this.index++] = by;
    }

    private void _putShort(int n) {
        this.event[this.index++] = (byte)(n >> 8 & 0xFF);
        this.event[this.index++] = (byte)(n & 0xFF);
    }

    private void _putInt(int n) {
        this.event[this.index++] = (byte)(n >> 24 & 0xFF);
        this.event[this.index++] = (byte)(n >> 16 & 0xFF);
        this.event[this.index++] = (byte)(n >> 8 & 0xFF);
        this.event[this.index++] = (byte)(n & 0xFF);
    }

    private void _putPad(int n) {
        this.index += n;
    }

    void putEvent(int n) {
        this.index = 4;
        this._putInt(n);
    }

    int getByte() {
        int n = 0;
        n = this.event[this.index++] & 0xFF;
        return n;
    }

    int getShort() {
        int n = 0;
        n = this.event[this.index++] & 0xFF;
        n = n << 8 & 0xFFFF | this.event[this.index++] & 0xFF;
        return n;
    }

    int getInt() {
        int n = 0;
        n = this.event[this.index++] & 0xFF;
        n = n << 8 & 0xFFFF | this.event[this.index++] & 0xFF;
        n = n << 8 & 0xFFFFFF | this.event[this.index++] & 0xFF;
        n = n << 8 | this.event[this.index++] & 0xFF;
        return n;
    }

    void init() {
        this.index = 0;
        this.type = this.getByte();
        this.code = this.getByte();
        this.seq = this.getShort();
    }

    static Event make(Display display, byte by) throws IOException {
        Event event;
        byte[] byArray = new byte[32];
        byArray[0] = by;
        display.server.getByte(byArray, 1, 31);
        by = (byte)(by & 0x7F & 0xFF);
        if (by == 28) {
            event = new PropertyNotify(byArray);
        } else if (by == 17) {
            event = new DestroyNotify(byArray);
        } else if (by == 22) {
            event = new ConfigureNotify(byArray);
        } else if (by == 31) {
            event = new SelectionNotify(byArray);
        } else if (by == 0) {
            event = new ErrorNotify(byArray);
            ErrorNotify errorNotify = (ErrorNotify)event;
            display.errReason = errorNotify.reason;
            display.errValue = errorNotify.value;
            display.errMinor = errorNotify.minor;
            display.errMajor = errorNotify.major;
        } else {
            event = new Event(byArray);
            event.type = by;
            event.index = 1;
            event.code = event.getByte();
            event.seq = event.getShort();
        }
        return event;
    }

    static {
        int n = 0;
        while (n < 32) {
            Event.zeros[n] = 0;
            ++n;
        }
    }
}

