/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jwax;

import com.jcraft.jwax.Atom;
import com.jcraft.jwax.ErrorNotify;
import com.jcraft.jwax.Event;
import com.jcraft.jwax.Format;
import com.jcraft.jwax.IO;
import com.jcraft.jwax.ReplyGetAtomName;
import com.jcraft.jwax.ReplyGetInputFocus;
import com.jcraft.jwax.ReplyGetProperty;
import com.jcraft.jwax.ReplyGetSelectionOwner;
import com.jcraft.jwax.ReplyInternAtom;
import com.jcraft.jwax.ReplyListProperties;
import com.jcraft.jwax.ReplyQueryTree;
import com.jcraft.jwax.Screen;
import com.jcraft.jwax.SelectionNotify;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public class Display {
    IO server;
    Event[] events = new Event[10];
    public static final int PropModeReplace = 0;
    public static final int PropModePrepend = 1;
    public static final int PropModeAppend = 2;
    public static final int PropertyNewValue = 0;
    public static final int PropertyDelete = 1;
    public int _XT_SELECTION_0;
    public int _XT_SELECTION_1;
    public int _WM_STATE;
    int seq;
    int data;
    int major;
    int minor;
    int relnum;
    int idbase;
    int idmask;
    int mbuffer;
    int mlen;
    int iborder;
    int bborder;
    int bSU;
    int bSp;
    int minkey;
    int maxkey;
    int nextid;
    byte[] vendor;
    Format[] format;
    Screen[] screen;
    String host = "localhost";
    int port = 6000;
    int errReason;
    int errValue;
    int errMinor;
    int errMajor;
    int window;

    int getWindow() throws IOException {
        if (this.window != 0) {
            return this.window;
        }
        this.window = this.getNextID();
        this.xCreateWindow(this.screen[0].rdepth, this.window, this.screen[0].rootWindow(), 0, 0, 1, 1, 0, 0, 0, 0, null);
        return this.window;
    }

    void parse(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return;
        }
        if (n != 1) {
            this.host = string.substring(0, n);
        }
        if ((n = (string = string.substring(n + 1)).indexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        try {
            this.port = 6000 + Integer.parseInt(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Display() {
        this("");
    }

    public Display(String string) {
        this.parse(string);
        try {
            Socket socket = new Socket(this.host, this.port);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            this.server = new IO(inputStream, outputStream);
            this.server.putByte((byte)66);
            this.server.putPad(1);
            this.server.putShort(11);
            this.server.putShort(0);
            this.server.putShort(0);
            this.server.putShort(0);
            this.server.putPad(2);
            this.server.flush();
            this.init();
            ReplyInternAtom replyInternAtom = this.xInternAtom(false, "_XT_SELECTION_0");
            this._XT_SELECTION_0 = replyInternAtom.atom;
            replyInternAtom = this.xInternAtom(false, "_XT_SELECTION_1");
            this._XT_SELECTION_1 = replyInternAtom.atom;
            replyInternAtom = this.xInternAtom(false, "WM_STATE");
            this._WM_STATE = replyInternAtom.atom;
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    int getNextID() {
        return this.nextid++;
    }

    void init() throws IOException {
        int n = this.server.getByte();
        this.server.getPad(1);
        this.major = this.server.getShort();
        this.minor = this.server.getShort();
        int n2 = this.server.getShort();
        this.relnum = this.server.getInt();
        this.idbase = this.server.getInt();
        this.idmask = this.server.getInt();
        this.nextid = this.idbase + 1;
        this.mbuffer = this.server.getInt();
        n = this.server.getShort();
        this.vendor = new byte[n];
        this.mlen = n = this.server.getShort();
        n = this.server.getByte();
        this.screen = new Screen[n];
        n = this.server.getByte();
        this.format = new Format[n];
        this.iborder = this.server.getByte();
        this.bborder = this.server.getByte();
        this.bSU = this.server.getByte();
        this.bSp = this.server.getByte();
        this.minkey = this.server.getByte();
        this.maxkey = this.server.getByte();
        this.server.getPad(4);
        this.server.getByte(this.vendor, 0, this.vendor.length);
        this.server.getPad(-this.vendor.length & 3);
        int n3 = 0;
        while (n3 < this.format.length) {
            this.format[n3] = Format.parse(this.server);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.screen.length) {
            this.screen[n4] = Screen.parse(this.server);
            ++n4;
        }
    }

    public Screen defaultScreen() {
        return this.screen[0];
    }

    public void xSendEvent(int n, int n2, int n3, Event event) throws IOException {
    }

    public ReplyInternAtom xInternAtom(boolean bl, String string) throws IOException {
        ++this.seq;
        this.errReason = 0;
        int n = string.length();
        this.server.putByte((byte)16);
        this.server.putByte((byte)(bl ? 1 : 0));
        this.server.putShort(2 + (n + 3) / 4);
        this.server.putShort(n);
        this.server.putPad(2);
        Object object = this.server;
        byte[] byArray = string.getBytes();
        ((IO)object).putByte(byArray, 0, byArray.length);
        this.server.putPad(-n & 3);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        object = new ReplyInternAtom();
        this.server.getPad(4);
        ((ReplyInternAtom)object).atom = this.server.getInt();
        this.server.getPad(20);
        return object;
    }

    public ReplyGetProperty xGetProperty(boolean bl, int n, int n2, int n3, int n4, int n5) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)20);
        this.server.putByte((byte)(bl ? 1 : 0));
        this.server.putShort(6);
        this.server.putInt(n);
        this.server.putInt(n2);
        this.server.putInt(n3);
        this.server.putInt(n4);
        this.server.putInt(n5);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyGetProperty replyGetProperty = new ReplyGetProperty();
        replyGetProperty.format = this.data;
        this.server.getInt();
        replyGetProperty.type = this.server.getInt();
        replyGetProperty.byte_after = this.server.getInt();
        replyGetProperty.lif = this.server.getInt();
        this.server.getPad(12);
        int n6 = replyGetProperty.lif * (replyGetProperty.format / 8);
        replyGetProperty.value = new byte[n6];
        IO iO = this.server;
        byte[] byArray = replyGetProperty.value;
        iO.getByte(byArray, 0, byArray.length);
        this.server.getPad(-n6 & 3);
        return replyGetProperty;
    }

    public ReplyGetAtomName xGetAtomName(int n) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)17);
        this.server.putPad(1);
        this.server.putShort(2);
        this.server.putInt(n);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyGetAtomName replyGetAtomName = new ReplyGetAtomName();
        int n2 = this.server.getInt();
        n2 = this.server.getShort();
        this.server.getPad(22);
        byte[] byArray = new byte[n2];
        IO iO = this.server;
        iO.getByte(byArray, 0, byArray.length);
        replyGetAtomName.name = new String(byArray);
        this.server.getPad(-n2 & 3);
        return replyGetAtomName;
    }

    public ReplyGetInputFocus xGetInputFocus() throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)43);
        this.server.putPad(1);
        this.server.putShort(1);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyGetInputFocus replyGetInputFocus = new ReplyGetInputFocus();
        replyGetInputFocus.revert_to = this.server.getByte();
        this.server.getPad(2);
        this.server.getInt();
        replyGetInputFocus.focus = this.server.getInt();
        this.server.getPad(20);
        return replyGetInputFocus;
    }

    public void xSync(boolean bl) throws IOException {
        this.xGetInputFocus();
        if (bl) {
            int n = 0;
            while (n < this.events.length) {
                this.events[n] = null;
                ++n;
            }
        }
    }

    public ReplyListProperties xListProperties(int n) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)21);
        this.server.putPad(1);
        this.server.putShort(2);
        this.server.putInt(n);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyListProperties replyListProperties = new ReplyListProperties();
        int n2 = this.server.getInt();
        this.server.getPad(2);
        this.server.getPad(22);
        replyListProperties.atoms = new int[n2];
        int n3 = 0;
        while (n3 < replyListProperties.atoms.length) {
            replyListProperties.atoms[n3] = this.server.getInt();
            ++n3;
        }
        return replyListProperties;
    }

    public ReplyGetSelectionOwner xGetSelectionOwner(int n) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)23);
        this.server.putPad(1);
        this.server.putShort(2);
        this.server.putInt(n);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyGetSelectionOwner replyGetSelectionOwner = new ReplyGetSelectionOwner();
        this.server.getInt();
        replyGetSelectionOwner.owner = this.server.getInt();
        this.server.getPad(20);
        return replyGetSelectionOwner;
    }

    public void xGrabServer() throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)36);
        this.server.putPad(1);
        this.server.putShort(1);
        this.server.flush();
    }

    public void xUngrabServer() throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)37);
        this.server.putPad(1);
        this.server.putShort(1);
        this.server.flush();
    }

    public void xConvertSelection(int n, int n2, int n3, int n4, int n5) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)24);
        this.server.putPad(1);
        this.server.putShort(6);
        this.server.putInt(n);
        this.server.putInt(n2);
        this.server.putInt(n3);
        this.server.putInt(n4);
        this.server.putInt(n5);
        this.server.flush();
    }

    public void xSetSelectionOwner(int n, int n2, int n3) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)22);
        this.server.putPad(1);
        this.server.putShort(4);
        this.server.putInt(n);
        this.server.putInt(n2);
        this.server.putInt(n3);
        this.server.flush();
    }

    public void xChangeProperty(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)18);
        this.server.putByte((byte)n);
        int n7 = n6 * (n5 / 8);
        this.server.putShort(6 + (n7 + 3) / 4);
        this.server.putInt(n2);
        this.server.putInt(n3);
        this.server.putInt(n4);
        this.server.putByte((byte)n5);
        this.server.putPad(3);
        this.server.putInt(n6);
        this.server.putByte(byArray, 0, n7);
        this.server.putPad(-n7 & 3);
        this.server.flush();
    }

    public void xSelectInput(int n, int n2) throws IOException {
        int[] nArray = new int[]{n2};
        this.xChangeWindowAttributes(n, 2048, nArray);
    }

    public byte[] xFetchBuffer(int n) throws IOException {
        if (n < 0 || n > 7) {
            return null;
        }
        ReplyGetProperty replyGetProperty = this.xGetProperty(false, this.screen[0].rootid, Atom.buffers[n], 31, 0, 100);
        if (replyGetProperty == null) {
            return null;
        }
        if (replyGetProperty.type == 31 && replyGetProperty.format != 32) {
            return replyGetProperty.value;
        }
        return null;
    }

    public byte[] xFetchBuffer() throws IOException {
        return this.xFetchBuffer(0);
    }

    public void xStoreBuffer(byte[] byArray) throws IOException {
        this.xStoreBuffer(byArray, 0);
    }

    public void xStoreBuffer(byte[] byArray, int n) throws IOException {
        if (n < 0 || n > 7) {
            return;
        }
        this.xChangeProperty(0, this.screen[0].rootid, Atom.buffers[n], 31, 8, byArray.length, byArray);
    }

    public void xRotateBuffers(int n) throws IOException {
        this.xRotateProperties(this.screen[0].rootid, Atom.buffers, n);
    }

    public void xRotateProperties(int n, int[] nArray, int n2) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)114);
        this.server.putPad(1);
        this.server.putShort(3 + nArray.length);
        this.server.putInt(n);
        this.server.putShort(nArray.length);
        this.server.putShort(n2);
        if (nArray.length != 0) {
            int n3 = 0;
            while (n3 < nArray.length) {
                this.server.putInt(nArray[n3]);
                ++n3;
            }
        }
        this.server.flush();
    }

    public void xChangeWindowAttributes(int n, int n2, int[] nArray) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)2);
        this.server.putPad(1);
        this.server.putShort(3 + nArray.length);
        this.server.putInt(n);
        this.server.putInt(n2);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.server.putInt(nArray[n3]);
            ++n3;
        }
        this.server.flush();
    }

    public void xDeleteProperty(int n, int n2) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)19);
        this.server.putPad(1);
        this.server.putShort(3);
        this.server.putInt(n);
        this.server.putInt(n2);
        this.server.flush();
    }

    public ReplyQueryTree xQueryTree(int n) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)15);
        this.server.putPad(1);
        this.server.putShort(2);
        this.server.putInt(n);
        this.server.flush();
        if (this.wait_for_reply() == 0) {
            return null;
        }
        ReplyQueryTree replyQueryTree = new ReplyQueryTree();
        int n2 = this.server.getInt();
        replyQueryTree.root = this.server.getInt();
        replyQueryTree.parent = this.server.getInt();
        this.server.getShort();
        this.server.getPad(14);
        replyQueryTree.children = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            replyQueryTree.children[n3] = this.server.getInt();
            ++n3;
        }
        return replyQueryTree;
    }

    void putEvent(Event event) {
        int n;
        for (n = 0; this.events.length > n && this.events[n] != null; ++n) {
        }
        if (n == this.events.length) {
            Event[] eventArray = new Event[this.events.length * 2];
            System.arraycopy(this.events, 0, eventArray, 0, this.events.length);
            n = this.events.length;
            this.events = eventArray;
        }
        this.events[n] = event;
    }

    public Event getEvent() throws IOException {
        Event event = this.events[0];
        if (event != null) {
            if (this.events[1] == null) {
                this.events[0] = null;
            } else {
                System.arraycopy(this.events, 1, this.events, 0, this.events.length - 1);
            }
        } else {
            int n = this.server.getByte();
            event = Event.make(this, (byte)n);
        }
        return event;
    }

    int wait_for_reply() throws IOException {
        int n = 1;
        while (true) {
            if ((n = this.server.getByte()) == 1) {
                this.data = this.server.getByte();
                n = this.server.getShort();
                if (n != this.seq) {
                    System.out.println("something wrong?? " + n + ", " + this.seq);
                }
                this.seq = n;
                break;
            }
            Event event = Event.make(this, (byte)n);
            if (n == 0 && event.seq == this.seq) break;
            if (n == 0) {
                System.out.println("error...: current seq=" + this.seq + ", e.seq=" + event.seq);
                break;
            }
            this.putEvent(event);
        }
        return n;
    }

    void print(PrintStream printStream) {
        int n;
        printStream.println("DISPLAY:");
        printStream.println("  major = " + this.major);
        printStream.println("  minor = " + this.minor);
        printStream.println("  RelaseNumber = " + this.relnum);
        printStream.println("  idbase = " + Integer.toHexString(this.idbase));
        printStream.println("  idmask = " + Integer.toHexString(this.idmask));
        printStream.println("  MotionBuffer = " + this.mbuffer);
        printStream.println("  mlen = " + this.mlen);
        printStream.println("  iborder = " + this.iborder);
        printStream.println("  bborder = " + this.bborder);
        printStream.println("  bSU = " + this.bSU);
        printStream.println("  bSp = " + this.bSp);
        printStream.println("  minkey = " + this.minkey);
        printStream.println("  maxkey = " + this.maxkey);
        printStream.println("  vendor = " + new String(this.vendor));
        if (this.format != null) {
            n = 0;
            while (n < this.format.length) {
                this.format[n].print(printStream);
                ++n;
            }
        }
        if (this.screen != null) {
            n = 0;
            while (n < this.screen.length) {
                this.screen[n].print(printStream);
                ++n;
            }
        }
    }

    public void xCreateWindow(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int[] nArray) throws IOException {
        ++this.seq;
        this.errReason = 0;
        this.server.putByte((byte)1);
        this.server.putByte((byte)n);
        this.server.putShort(8 + (nArray == null ? 0 : nArray.length));
        this.server.putInt(n2);
        this.server.putInt(n3);
        this.server.putShort(n4);
        this.server.putShort(n5);
        this.server.putShort(n6);
        this.server.putShort(n7);
        this.server.putShort(n8);
        this.server.putShort(n9);
        this.server.putInt(n10);
        this.server.putInt(n11);
        if (nArray != null) {
            int n12 = 0;
            while (n12 < nArray.length) {
                this.server.putInt(nArray[n12]);
                ++n12;
            }
        }
        this.server.flush();
    }

    public byte[] xtGetSelectionValue(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this._XT_SELECTION_0;
        return this.xtGetSelectionValue(n, n2, n3, n5, n4);
    }

    public byte[] xtGetSelectionValue(int n, int n2, int n3, int n4, int n5) throws IOException {
        this.xConvertSelection(n, n2, n3, n4, n5);
        Event event = null;
        while (!((event = this.getEvent()) instanceof SelectionNotify)) {
            if (!(event instanceof ErrorNotify)) continue;
            return null;
        }
        SelectionNotify selectionNotify = (SelectionNotify)event;
        ReplyGetProperty replyGetProperty = this.xGetProperty(true, selectionNotify.requestor, selectionNotify.property, 0, 0, 100);
        if (replyGetProperty == null) {
            return null;
        }
        return replyGetProperty.value;
    }

    public int xmuClientWindow(int n) throws IOException {
        ReplyGetProperty replyGetProperty = this.xGetProperty(false, n, this._WM_STATE, 0, 0, 100);
        if (replyGetProperty != null && replyGetProperty.type != 0) {
            return n;
        }
        int n2 = this.tryChildren(n, this._WM_STATE);
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    int tryChildren(int n, int n2) throws IOException {
        int n3 = 0;
        ReplyQueryTree replyQueryTree = this.xQueryTree(n);
        if (replyQueryTree == null) {
            return n3;
        }
        int n4 = 0;
        while (n4 < replyQueryTree.children.length) {
            ReplyGetProperty replyGetProperty = this.xGetProperty(false, replyQueryTree.children[n4], n2, 0, 0, 100);
            if (replyGetProperty != null && replyGetProperty.type != 0) {
                n3 = replyQueryTree.children[n4];
                break;
            }
            ++n4;
        }
        if (n3 == 0) {
            int n5 = 0;
            while (n5 < replyQueryTree.children.length) {
                n3 = this.tryChildren(replyQueryTree.children[n5], n2);
                if (n3 != 0) break;
                ++n5;
            }
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        Display display = new Display("");
        try {
            int n = display.getWindow();
            byte[] byArray = display.xtGetSelectionValue(n, 1, 31, (int)System.currentTimeMillis());
            System.out.println(new String(byArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void properties(int n, int n2) throws IOException {
        ReplyQueryTree replyQueryTree;
        int n3;
        ReplyListProperties replyListProperties = this.xListProperties(n);
        if (replyListProperties != null) {
            int n4 = 0;
            while (n4 < n2) {
                System.out.print(" ");
                ++n4;
            }
            System.out.println(String.valueOf(Integer.toHexString(n)) + ": ");
            if (replyListProperties.atoms != null) {
                n3 = 0;
                while (n3 < replyListProperties.atoms.length) {
                    int n5 = 0;
                    while (n5 < n2) {
                        System.out.print(" ");
                        ++n5;
                    }
                    ReplyGetAtomName replyGetAtomName = this.xGetAtomName(replyListProperties.atoms[n3]);
                    System.out.print(String.valueOf(replyGetAtomName.name) + " -> ");
                    ReplyGetProperty replyGetProperty = this.xGetProperty(false, n, replyListProperties.atoms[n3], 0, 0, 100);
                    if (replyGetProperty != null) {
                        System.out.println(new String(replyGetProperty.value));
                    }
                    ++n3;
                }
            }
        }
        if ((replyQueryTree = this.xQueryTree(n)) == null) {
            return;
        }
        n3 = 0;
        while (n3 < replyQueryTree.children.length) {
            this.properties(replyQueryTree.children[n3], n2 + 2);
            ++n3;
        }
    }
}

