/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class WriteBuffer {
  private int bufferSize;
  private int numBytesInBuffer;
  private int start=0;
  private boolean bigEndian=false;

  byte[] buffer=null;
  private int save=0;
  WriteBuffer(){
    this(1024);
  }
  WriteBuffer(int size){
    bufferSize=size;
    numBytesInBuffer=0;
    buffer=new byte[size];
  }
  int addMessage(int numBytes){
    if(numBytesInBuffer+numBytes>bufferSize){
      bufferSize=numBytesInBuffer+numBytes;
      byte[] newBuffer=new byte[bufferSize];
      System.arraycopy(buffer, 0, newBuffer, 0, numBytesInBuffer);
      buffer=newBuffer;
    }
    start=numBytesInBuffer;
    numBytesInBuffer+=numBytes;
    return start;
  }
  byte[] getData(){
    return buffer;
  }
  int getLength(){
    return numBytesInBuffer;
  }
  void reset(){
    numBytesInBuffer = 0;
    start=0;
  }

  void registerPointer(){ registerPointer(start); }
  void registerPointer(int ptr){ save=ptr; }
  void unregisterPointer(){ start=save; }

  void putUINT(int value, int start_){
    start_+=start;
    if(bigEndian){
      buffer[start_+1]=(byte)(value/*&0xff*/);
      value>>>=8;
      buffer[start_]=(byte)value;
    }
    else{
      buffer[start_]=(byte)(value/*&0xff*/);
      value>>>=8;
      buffer[start_+1]=(byte)value;
    }
  }
  void putULONG(int value, int start_){
    start_+=start;
    if(bigEndian){
      start_+=3;
      for(int i=4; i>0; i--){
        buffer[start_--]=(byte)(value/*&0xff*/);
	value>>>=8;
      }
    }
    else{
      for(int i=4; i>0; i--){
	buffer[start_++]=(byte)(value/*&0xff*/);
	value>>>=8;
      }
    }
  }
  void setBigEndian(boolean flag){
    bigEndian = flag;
  }
}
