/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class TextCompressor{
  private CharCache[] cache=null;
  private int key=0;

  TextCompressor(CharCache[] cache){
    this.cache=cache;
  }

  void encodeChar(byte ch, EncodeBuffer encodeBuffer){
    CharCache foo=cache[key%cache.length];
    if((key>=128)&&(foo.getSize()==0)){
      CharCache bar=cache[(key&0x7f)%cache.length];
      encodeBuffer.encodeCachedValue((byte)ch, 8, bar);
      foo.insert(ch);
    }
    else{
      encodeBuffer.encodeCachedValue((byte)ch, 8, foo);
    }
    key=(((key&0x1f)<<7)|((key&0x380)<<5)|(ch&0x7f));
  }

  byte[] nextChar=new byte[1];
  byte decodeChar(DecodeBuffer decodeBuffer){
    CharCache foo=cache[key%cache.length];
    if((key>=128)&&(foo.getSize()==0)){
      CharCache bar=cache[(key&0x7f)%cache.length];
      decodeBuffer.decodeCachedValue(nextChar, 8, bar);
      foo.insert((byte)(nextChar[0]&0xff));
    }
    else{
      decodeBuffer.decodeCachedValue(nextChar, 8, foo);
    }
    key=(((key&0x1f)<<7)|((key&0x380)<<5)|(nextChar[0]&0x7f));
    return (byte)(nextChar[0]&0xff);
  }
  void reset(){ reset(0); }
  void reset(int newKey){ key=newKey; }
}
