/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.util.*;

class ServerReadBuffer extends ReadBuffer{
  boolean locateMessage(){
    int size=inend-instart;
    if(size<8)return false;
    if(firstMessage){
      dataLength=8+(getUINT(inbuffer, instart+6)<<2);
    }
    else{
      if(inbuffer[instart]==1){
	dataLength=32+(getULONG(inbuffer, instart+4)<<2);
      }
      else{
	dataLength=32;
      }
    }

    if(size<dataLength){
      while(true){
	if(inbuffer.length<dataLength){
          byte[] foo=new byte[inbuffer.length*2];
          System.arraycopy(inbuffer, 0, foo, 0, inbuffer.length);
	  inbuffer=foo;
          continue;
        }
        break;
      }
      try{ read(dataLength); }catch(Exception e){}
      if(dataLength<=inrest)return true;
      return false;
    }
    firstMessage=false;
    headerLength=0;
    trailerLength=0;
    return true;
  }
}
