/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.net.*;
import java.lang.*;

public class ServerProxy extends Proxy{
  int serverPort=6000;
  String serverHost="127.0.0.1";
  public ServerProxy()throws IOException{
    super();
  }
  public ServerProxy(String host)throws IOException{
    super(host);
  }
  public ServerProxy(int dxpcport)throws IOException{
    super(dxpcport);
  }
  public ServerProxy (int xport, int dxpcport) throws IOException{
    super (dxpcport);
    setServerPort (xport);
    setServerHost ("localhost");
  }
  ServerProxy (Socket socket) throws IOException{
    super(socket);
  }
  Channel createChannel(){
    Channel foo=new ServerChannel(serverHost, serverPort);
    foo.setProxy(this); 
    return foo;
  }
  public void setServerPort(int port){serverPort=port;}
  public void setServerHost(String host){serverHost=host;}
  public static void main(String[] arg){
    ServerProxy sp;
    try{
      if (arg.length == 2){
        //format: xport dxpcport
        int xport = Integer.parseInt (arg[0]);
        int dxpcport = Integer.parseInt (arg[1]);
        sp = new ServerProxy (xport, dxpcport);
      }
      else if (arg.length > 0){
        sp = new ServerProxy (arg[0]);
      }
      else{
        sp = new ServerProxy ();
      }
    }
    catch (IOException e){
      System.err.println ("cannot connect");
      return;
    }
    sp.start ();
  }
}
