/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class ServerCache {
  static final int SERVER_TEXT_CACHE_SIZE = 9999;

  // General-purpose caches:
  CharCache[] textCache = new CharCache[SERVER_TEXT_CACHE_SIZE];
  int lastSequenceNum=0;
  IntCache replySequenceNumCache = new IntCache(6);
  IntCache eventSequenceNumCache = new IntCache(6);
  int lastTimestamp=0;
  CharCache depthCache = new CharCache();
  IntCache visualCache = new IntCache(8);
  IntCache colormapCache = new IntCache(8);

  // Opcode prediction caches (predict next opcode based on previous one)
  CharCache[] opcodeCache= new CharCache[256];
  int lastOpcode=0;

  // X connection startup
  static BlockCache lastInitReply = new BlockCache();

  // X errors
  CharCache errorCodeCache = new CharCache();
  IntCache errorMinorCache = new IntCache(8);
  CharCache errorMajorCache = new CharCache();

  // ButtonPress and ButtonRelease events
  CharCache buttonCache = new CharCache();

  // ColormapNotify event
  IntCache colormapNotifyWindowCache = new IntCache(8);
  IntCache colormapNotifyColormapCache = new IntCache(8);

  // ConfigureNotify event
  IntCache[] configureNotifyWindowCache = new IntCache[3];
  IntCache[] configureNotifyGeomCache = new IntCache[5];

  // CreateNotify event
  IntCache createNotifyWindowCache = new IntCache(8);
  int createNotifyLastWindow=0;

  // Expose event
  IntCache exposeWindowCache = new IntCache(12);
  IntCache[] exposeGeomCache = new IntCache[5];

  // FocusIn event
  // (also used for FocusOut)
  IntCache focusInWindowCache = new IntCache(8);

  // KeymapNotify event
  static BlockCache lastKeymap = new BlockCache();

  // KeyPress event
  byte keyPressLastKey=0;
  byte[] keyPressCache = new byte[23];

  // MapNotify event
  // (also used for UnmapNotify)
  IntCache mapNotifyEventCache = new IntCache(8);
  IntCache mapNotifyWindowCache = new IntCache(8);

  // MotionNotify event
  // (also used for KeyPress, KeyRelease, ButtonPress, ButtonRelease,
  //  EnterNotify, and LeaveNotify events and QueryPointer reply)
  IntCache motionNotifyTimestampCache = new IntCache(8);
  int motionNotifyLastRootX=0;
  int motionNotifyLastRootY=0;
  IntCache motionNotifyRootXCache = new IntCache(8);
  IntCache motionNotifyRootYCache = new IntCache(8);
  IntCache motionNotifyEventXCache = new IntCache(8);
  IntCache motionNotifyEventYCache = new IntCache(8);
  IntCache motionNotifyStateCache = new IntCache(8);
  IntCache[] motionNotifyWindowCache = new IntCache[3];

  // NoExpose event
  IntCache noExposeDrawableCache = new IntCache(8);
  IntCache noExposeMinorCache = new IntCache(8);
  CharCache noExposeMajorCache = new CharCache();

  // PropertyNotify event
  IntCache propertyNotifyWindowCache = new IntCache(8);
  IntCache propertyNotifyAtomCache = new IntCache(8);

  // ReparentNotify event
  IntCache reparentNotifyWindowCache = new IntCache(8);

  // SelectionClear event
  IntCache selectionClearWindowCache = new IntCache(8);
  IntCache selectionClearAtomCache = new IntCache(8);

  // VisibilityNotify event
  IntCache visibilityNotifyWindowCache = new IntCache(8);


  // GetGeometry reply
  IntCache getGeometryRootCache = new IntCache(8);
  IntCache[] getGeometryGeomCache = new IntCache[5];

  // GetInputFocus reply
  IntCache getInputFocusWindowCache = new IntCache(8);

  // GetKeyboardMapping reply
  static byte getKeyboardMappingLastKeysymsPerKeycode=(byte)0;
  static BlockCache getKeyboardMappingLastMap = new BlockCache();
  IntCache getKeyboardMappingKeysymCache = new IntCache(8);
  CharCache getKeyboardMappingLastByteCache = new CharCache();

  // GetModifierMapping reply
  static BlockCache getModifierMappingLastMap = new BlockCache();

  // GetProperty reply
  CharCache getPropertyFormatCache = new CharCache();
  IntCache getPropertyTypeCache = new IntCache(8);
  TextCompressor getPropertyTextCompressor = new TextCompressor(textCache);
  static BlockCache xResources = new BlockCache();

  // GetSelection reply
  IntCache getSelectionOwnerCache = new IntCache(8);

  // GetWindowAttributes reply
  IntCache getWindowAttributesClassCache = new IntCache(8);
  CharCache getWindowAttributesBitGravityCache = new CharCache();
  CharCache getWindowAttributesWinGravityCache = new CharCache();
  IntCache getWindowAttributesPlanesCache = new IntCache(8);
  IntCache getWindowAttributesPixelCache = new IntCache(8);
  IntCache getWindowAttributesAllEventsCache = new IntCache(8);
  IntCache getWindowAttributesYourEventsCache = new IntCache(8);
  IntCache getWindowAttributesDontPropagateCache = new IntCache(8);

  // QueryColors reply
  BlockCache queryColorsLastReply = new BlockCache();

  // QueryFont reply
  static BlockCacheSet queryFontFontCache = new BlockCacheSet(16);

  IntCache[] queryFontCharInfoCache = new IntCache[6];
  int[] queryFontLastCharInfo = new int[6];

  // QueryPointer reply
  IntCache queryPointerRootCache = new IntCache(8);
  IntCache queryPointerChildCache = new IntCache(8);

  // TranslateCoords reply
  IntCache translateCoordsChildCache = new IntCache(8);
  IntCache translateCoordsXCache = new IntCache(8);
  IntCache translateCoordsYCache = new IntCache(8);

  ServerCache(){
    for(int i=0; i<textCache.length; i++) textCache[i]=new CharCache();
    for(int i=0; i<opcodeCache.length; i++) opcodeCache[i]=new CharCache();
    for(int i=0; i<configureNotifyWindowCache.length; i++)
      configureNotifyWindowCache[i] = new IntCache(8);
    for(int i=0; i<configureNotifyGeomCache.length; i++)
      configureNotifyGeomCache[i] = new IntCache(8);
    for(int i=0; i<exposeGeomCache.length; i++)
      exposeGeomCache[i] = new IntCache(8);
    for(int i=0; i<motionNotifyWindowCache.length; i++)
      motionNotifyWindowCache[i] = new IntCache(8);
    for(int i=0; i<getGeometryGeomCache.length; i++)
      getGeometryGeomCache[i] = new IntCache(8);
    for(int i=0; i<keyPressCache.length; i++)
      keyPressCache[i]=0;

    for(int i=0; i<queryFontCharInfoCache.length; i++){
      queryFontCharInfoCache[i] = new IntCache(8);
      queryFontLastCharInfo[i] = 0;
    }
  }
}
