/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class SequenceNumQueue {
  private static final int INITIALSIZE = 16;
  private static final int GROWTH_INCREMENT = 16;

  class RequestSequenceNum{
    int sequenceNum;
    int requestOpcode;
    int data1, data2, data3;
  };

  RequestSequenceNum[] queue;
  int length=0;
  int startIndex=0;
  int endIndex=0;

  SequenceNumQueue(){
    queue=new RequestSequenceNum[INITIALSIZE];
    for(int i=0; i<INITIALSIZE; i++){
      queue[i]=new RequestSequenceNum();
    }
  }

  void push(int sequenceNum, int requestOpcode){
    push(sequenceNum, requestOpcode, 0, 0, 0);
  }
  void push(int sequenceNum, int requestOpcode, int data1){
    push(sequenceNum, requestOpcode, data1, 0, 0);
  }
  void push(int sequenceNum, int requestOpcode, int data1, int data2){
    push(sequenceNum, requestOpcode, data1, data2, 0);
  }

  void push(int sequenceNum, int requestOpcode,
	    int data1, int data2, int data3){
    if(length==0){
      startIndex=endIndex=0;
      queue[0].sequenceNum=sequenceNum;
      queue[0].requestOpcode=requestOpcode;
      queue[0].data1=data1;
      queue[0].data2=data2;
      queue[0].data3=data3;
      length=1;
      return;
    }

    if(length==queue.length){
      RequestSequenceNum[] foo = 
	new RequestSequenceNum[queue.length+GROWTH_INCREMENT];
      System.arraycopy(queue, startIndex, foo, 0, length-startIndex);
      //for (int i = startIndex_; (unsigned int) i < length_; i++)
      //  newQueue[i - startIndex_] = queue_[i];
      System.arraycopy(queue, 0, foo, startIndex, startIndex);
      //for (int i1 = 0; (unsigned int) i1 < startIndex_; i1++)
      //  newQueue[i1 + startIndex_] = queue_[i1];
      for(int i=0; i<foo.length; i++){
	if(foo[i]==null){
  	  foo[i]=new RequestSequenceNum();
	}
      }
      queue=foo;
      startIndex=0;
      endIndex=length-1;
    }
    endIndex++;
    if(endIndex==queue.length){
      endIndex=0;
    }
    queue[endIndex].sequenceNum=sequenceNum;
    queue[endIndex].requestOpcode=requestOpcode;
    queue[endIndex].data1=data1;
    queue[endIndex].data2=data2;
    queue[endIndex].data3=data3;
    length++;
  }

  boolean peek(int[] sequenceNum, int[] requestOpcode){
    if(length==0){ return false;}
    else{
      sequenceNum[0]=queue[startIndex].sequenceNum;
      requestOpcode[0]=queue[startIndex].requestOpcode;
      return true;
    }
  }
  boolean pop(int[] sequenceNum, int[] requestOpcode,
	  int[] data1, int[] data2, int[] data3){
    if(length==0){ return false; }
    else{
      sequenceNum[0]=queue[startIndex].sequenceNum;
      requestOpcode[0]=queue[startIndex].requestOpcode;
      if(data1!=null){
	data1[0]=queue[startIndex].data1;
	data2[0]=queue[startIndex].data2;
	data3[0]=queue[startIndex].data3;
      }
      startIndex++;
      if(startIndex==queue.length){
	startIndex=0;
      }
      length--;
      return true;
    }
  }
  boolean pop(int[] sequenceNum, int[] requestOpcode){
    return pop(sequenceNum, requestOpcode, null, null, null);
  }
}
