/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.net.*;
import java.security.KeyStore;
import javax.net.*;
import javax.net.ssl.*;
import javax.security.cert.X509Certificate;
import com.sun.net.ssl.*;

class SSLClientProxy{
  public static void main(String arg[]){
    byte[] buff=new byte[1024];
    try{
      {
        java.util.Properties prop=new java.util.Properties(System.getProperties());
        File foo=new File("./misc/prop");
        prop.load(new FileInputStream(foo));
        System.setProperties(prop);
      }

      int len;
      String keystore=System.getProperty("com.jcraft.jdxpc.keystore");
      String storepass=System.getProperty("com.jcraft.jdxpc.storepass");
      String keypass=System.getProperty("com.jcraft.jdxpc.keypass");

      if(keystore==null){
        System.out.print("keystore: ");
        len=System.in.read(buff, 0, buff.length);
        keystore=new String(buff, 0, len-1);
      }

      if(storepass==null){
        System.out.print("storepass: ");
        len=System.in.read(buff, 0, buff.length);
        storepass=new String(buff, 0, len-1);
      }

      if(keypass==null){
        System.out.print("keypass: ");
        len=System.in.read(buff, 0, buff.length);
        keypass=new String(buff, 0, len-1);
      }

      ServerSocketFactory ssf=getServerSocketFactory(keystore, 
                                                     storepass,
						     keypass);
      ServerSocket ss=ssf.createServerSocket(Proxy.defaultPort);

      disableRSA((SSLServerSocket)ss);

      System.out.println("SSLClientProxy starts.");
      (new ClientProxy(ss)).start();
    }
    catch(IOException e){
      e.printStackTrace();
    }
  }

  private static ServerSocketFactory getServerSocketFactory(String keystore,
							    String keystorePass,
							    String passphrase){
    try{
      SSLContext ctx=SSLContext.getInstance("TLS");
      KeyManagerFactory kmf=KeyManagerFactory.getInstance("SunX509");
      KeyStore ks=KeyStore.getInstance("JKS");
      ks.load(new FileInputStream(keystore), keystorePass.toCharArray());
      kmf.init(ks, passphrase.toCharArray());
      ctx.init(kmf.getKeyManagers(), null, null);
      SSLServerSocketFactory ssf=ctx.getServerSocketFactory();
      return ssf;
    }
    catch(Exception e){
      e.printStackTrace();
    }
    return null;
  }

  private static void disableRSA(SSLServerSocket ss){
    String[] tmp=ss.getEnabledCipherSuites();
    java.util.Vector foo=new java.util.Vector();
    for(int i=0; i<tmp.length; i++){
      //System.out.println(tmp[i]);
      if(tmp[i].indexOf("RSA")==-1) foo.addElement(tmp[i]);
    }
    tmp=new String[foo.size()];
    for(int i=0; i<tmp.length; i++){ tmp[i]=(String)foo.elementAt(i); }
    ss.setEnabledCipherSuites(tmp);

    //tmp=ss.getEnabledCipherSuites();
    //for(int i=0; i<tmp.length; i++){System.out.println(tmp[i]);}
  }
}
