/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.util.*;

abstract class ReadBuffer {
  protected int headerLength;
  protected int dataLength;
  protected int trailerLength;
  protected boolean firstMessage=true;
  protected Thread readingthread;
  int messageStart;
  int messageLength;
  InputStream in=null;
  static final int BUFFERSIZE=1024;
  byte[] inbuffer=new byte[BUFFERSIZE];
  int instart=0, inend=0, inrest=0;
  boolean bigEndian=false;
  boolean running;    

//boolean expand=false;

  ReadBuffer(){ 
  }

  void setInputStream(InputStream in){this.in=in; }

  int available() throws java.io.IOException{
    if(0<inrest) return 1;
    return in.available();
  }

  void getByte(byte[] array) throws java.io.IOException{
    getByte(array, 0, array.length);
  }
  void getByte(byte[] array, int begin, int length) throws java.io.IOException{
    int i=inrest;
    if(0<i){
      if(length<i)i=length;
      System.arraycopy(inbuffer, instart, array, begin, i);
      length-=i;
      begin+=i;
      instart+=i;
      inrest-=i;
      if(length==0) return;
    }
    while(true){
      i=in.read(array, begin, length);
      if(i==-1){ throw new IOException(); }
      begin+=i;
      length-=i;
      if(length==0)break;
    }
  }

  protected final void read(int n) throws java.io.IOException{
    if(instart>0 && inrest>0){
      System.arraycopy(inbuffer, instart, inbuffer, 0, inrest);
    }
    if(inrest==inbuffer.length) return;

    if (n>inbuffer.length){
      n=inbuffer.length;
    }
    instart=0;
    inend=inrest;
    int i = 0, a, bytes2read;
    running = true;
    readingthread = Thread.currentThread ();
    while (running){
      // make sure the thing is not blocking (if it is wanted)
      a = in.available ();
      bytes2read = inbuffer.length - inend;
      try {
        i = in.read (inbuffer, inend, bytes2read);
      }
      catch (Exception e) {
        System.out.println ("inread: " + e);
	throw new IOException ();
      }
      if (i == -1) {
        throw new IOException ();
      }
      inend += i;
      if (n <= inend)
        break;
    }
    inrest=inend;
  }

  void close() throws java.io.IOException{
    running = false;
    in.close();
    readingthread.interrupt ();	// we need this, because the in.read in read blocks
  }

  void doRead() throws java.io.IOException{
    if(inrest<1){
      read(1);
    }
  }

  byte[] getMessage(int[] messageStart, int[] messageLength){
    if(locateMessage()){
      messageStart[0]=instart;
      messageLength[0]=dataLength;

      if(dataLength!=0) messageStart[0]+=headerLength;
      else messageLength[0]+=headerLength;

      this.messageStart=messageStart[0];
      this.messageLength=messageLength[0];

      instart+=(headerLength+dataLength+trailerLength);
      inrest-=(headerLength+dataLength+trailerLength);
      return inbuffer;
    }
    return null;
  }

  abstract boolean locateMessage();

  void setBigEndian(boolean flag){
    bigEndian=flag;
  }

  int getUINT(int start){
    start+=messageStart;
    int result;
    if(bigEndian){
      result=(inbuffer[start]&0xff);
      result<<=8;
      result+=(inbuffer[start+1]&0xff);
    }
    else{
      result=(inbuffer[start+1]&0xff);
      result<<= 8;
      result+=(inbuffer[start]&0xff);
    }
    return result;
  }
  int getULONG(int start){
    start+=messageStart;
    int next = (bigEndian ? start : start+3);
    int result = 0;
    for(int i=0; i<4; i++){
      result <<= 8;
      result += (inbuffer[next]&0xff);
      if(bigEndian) next++;
      else next--;
    }
    return result;
  }

  int getULONG(int start, boolean _endian){
    start+=messageStart;
    int next = (_endian ? start : start+3);
    int result = 0;
    for(int i=0; i<4; i++){
      result <<= 8;
      result += (inbuffer[next]&0xff);
      if(_endian) next++;
      else next--;
    }
    return result;
  }

  int getUINT(byte[] buffer, int start){
    int result;
    if(bigEndian){
      result=(buffer[start]&0xff);
      result<<=8;
      result+=(buffer[start+1]&0xff);
    }
    else{
      result=(buffer[start+1]&0xff);
      result<<=8;
      result+=(buffer[start]&0xff);
    }
    return result;
  }
  int getULONG(byte[] buffer, int start){
    int next=(bigEndian ? start : start+3);
    int result=0;
    for(int i=0; i<4; i++){
      result<<=8;
      result+=(buffer[next]&0xff);
      if(bigEndian) next++;
      else next--;
    }
    return result;
  }
}
