/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.util.*;

class ProxyReadBuffer extends ReadBuffer{
  boolean locateMessage(){
    int lengthLength=0;
    dataLength=0;
    int nextSrc=instart;
    int next;
    do{
      if(nextSrc>=inend){
	return false;
      }
      next=(inbuffer[nextSrc])&0xff; nextSrc++;
      dataLength<<=7;
      dataLength|=((next&0x7f)&0xff);
      lengthLength++;
    }
    while((next&0x80)!=0);

    trailerLength=0;
    headerLength=(dataLength==0 ? 3: lengthLength);
    int totalLength=headerLength+dataLength+trailerLength;

    if(instart+totalLength>inend){
      while(true){
        if(inbuffer.length<totalLength){
	  byte[] foo=new byte[inbuffer.length*2];
	  System.arraycopy(inbuffer, 0, foo, 0, inbuffer.length);
	  inbuffer=foo;
          continue;
        }
	break;
      }
      try{ read(totalLength); }catch(IOException e){}
      if(totalLength<=inrest)return true;
      return false;
    }
    else{
      return true;
    }
  }
}
