/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.net.*;
import java.lang.*;

abstract class Proxy extends Thread{
  public static String version="0.0.4";
  private static byte[] incantation="DXPC 3.7 ".getBytes();
  static { incantation[incantation.length-1]=(byte)0; }

  private static final int CTRL_NEW_CONNECTION=0;
  private static final int CTRL_DROP_CONNECTION=1;
  private static final int CTRL_SWITCH_CONNECTION=2;

  static final int defaultPort=4000;

  private InputStream proxyIn=null;
  private OutputStream proxyOut=null;
  private Channel currentInputChannel=null;
  private int currentOutputChannel=-1;

  private static Channel[] channels=new Channel[10];
  static synchronized void add(Channel foo){
    for(int i=0; i<channels.length; i++){
      if(channels[i]==null){
	channels[i]=foo;
	return;
      }
    }
    Channel[] bar=new Channel[channels.length*2];
    System.arraycopy(channels, 0, bar, 0, channels.length);
    bar[channels.length]=foo;
    channels=bar;
  }
  private static synchronized Channel delete(int id){
    for(int i=0; i<channels.length; i++){
      if(channels[i]!=null && channels[i].getId()==id){
	Channel foo=channels[i];
	channels[i]=null;
	return foo;
      }
    }
    return null;
  }
  private static synchronized Channel get(int id){
    for(int i=0; i<channels.length; i++){
      if(channels[i]!=null && channels[i].getId()==id) return channels[i];
    }
    return null;
  }

  abstract Channel createChannel();

  Proxy(){ this(defaultPort, (ServerSocket)null); }
  Proxy(int port){ this(port, (ServerSocket)null); }
  Proxy(ServerSocket ss){ this(0, ss); }
  Proxy(int port, ServerSocket ss){
    try	{
      //ServerSocket ss=ssf.createServerSocket(port);
      if(ss==null)ss=new ServerSocket(port);
      Socket socket=ss.accept();
      proxyIn=socket.getInputStream();
      proxyOut=socket.getOutputStream();
      proxyOut.write(incantation, 0, incantation.length);
    }
    catch(Exception e){
    }
  }

  Proxy(String host){ this(host, defaultPort, (Socket)null); }
  Proxy(String host, int port){ this(host, port, (Socket)null); }
  Proxy(Socket s){ this((String)null, 0, s); }
  Proxy(String host, int port, Socket s){
    try	{
      //Socket socket=new Socket(host, port);
      if(s==null) s=new Socket(host, port);
      proxyIn=s.getInputStream();
      proxyOut=s.getOutputStream();
      int len=0;
      try {
	byte[] foo=new byte[1024];
	len=proxyIn.read(foo, 0, foo.length);
      } 
      catch (IOException ee) {
	System.out.println(ee);
      }
    }
    catch(Exception e){
    }
  }

  public void run(){
//    ReadBuffer rBuffer=new ReadBuffer();
    ProxyReadBuffer rBuffer=new ProxyReadBuffer();
    rBuffer.setInputStream(proxyIn);

    byte[] buff=null;
    int[] start=new int[1];
    int[] length=new int[1];

    try{
    while(true){
      rBuffer.doRead();
      buff=rBuffer.getMessage(start, length);
//if(buff==null) continue;
if(buff==null){
  break;
}
      if(length[0]==3 && buff[start[0]]==0){
	int foo=buff[start[0]+1];
	int bar=buff[start[0]+2];
	switch(foo){
	case CTRL_NEW_CONNECTION:
	  //System.out.println("new connect="+bar);
	  currentInputChannel=createChannel();
	  currentInputChannel.setId(bar);
	  add(currentInputChannel);
	  currentInputChannel.start();
	  break;
	case CTRL_DROP_CONNECTION:
	  {
	    //System.out.println("drop connect="+bar);
	    Channel goo=delete(bar);
	    if(goo!=null) goo.close();
	  }
	  break;
	case CTRL_SWITCH_CONNECTION:
	  {
	    //System.out.println("switch channel="+bar);
	    Channel goo=get(bar);
	    if(goo!=null) currentInputChannel=goo;
	  }
	  break;
	default:
	}
      }
      else{
	currentInputChannel.doWrite(buff, start[0], length[0]);
      }
    }
    }
    catch(Exception e){
    }
  }

  private byte[] cMessages=new byte[9];
  private int cMessagesLength=0;
  private byte[] lengthb=new byte[5];

  synchronized void proxyWrite(int channelNum, EncodeBuffer eBuffer){
    cMessagesLength=0;
    if(channelNum!=currentOutputChannel){
      currentOutputChannel=channelNum;
      cMessages[cMessagesLength++]=0;
      cMessages[cMessagesLength++]=CTRL_SWITCH_CONNECTION;
      cMessages[cMessagesLength++]=(byte)currentOutputChannel;
    }
    int dataLength=eBuffer.getDataLength();

    if(dataLength+cMessagesLength!=0){
      int lengthLength=0;
      int len=dataLength;
      while(len>0){
	lengthb[lengthLength++]=(byte)(len&0x7f);
	len>>=7;
      }

      byte[] data=eBuffer.getData();
      int messageStart=eBuffer.PREFIX_SIZE-(cMessagesLength+lengthLength);
      int messageLength=dataLength+cMessagesLength+lengthLength;
      int nextDest=messageStart;
      for(int i=0; i<cMessagesLength; i++){
	data[nextDest++]=cMessages[i];
      }
      for(int i=lengthLength-1 ; i>0; i--){
	data[nextDest++]=(byte)(lengthb[i]|0x80);
      }
      if(lengthLength>0){ 
	data[nextDest++]=(lengthb[0]);
      }

      try {
	proxyOut.write(data, messageStart, messageLength);
      } catch (IOException e) {
	//System.out.println("proxyputByte: "+e);
      }
    }
  }

  synchronized void proxyDrop(int channelNum, EncodeBuffer eBuffer){
    cMessagesLength=0;
    currentOutputChannel=channelNum;
    cMessages[cMessagesLength++]=0;
    cMessages[cMessagesLength++]=CTRL_DROP_CONNECTION;
    cMessages[cMessagesLength++]=(byte)currentOutputChannel;

    byte[] data=eBuffer.getData();
    int messageStart=eBuffer.PREFIX_SIZE-(cMessagesLength);
    int messageLength=cMessagesLength;
    int nextDest=messageStart;
    for(int i=0; i<cMessagesLength; i++){
      data[nextDest++]=cMessages[i];
    }

    try {
      proxyOut.write(data, messageStart, messageLength);
    } catch (IOException e) {
      //System.out.println("proxyputByte: "+e);
    }
    Channel foo=delete(channelNum);
    if(foo!=null) foo.close();
  }

  /*synchronized */void proxyNew(int channelNum, byte[] data){
    cMessagesLength=0;
//    if(channelNum!=currentOutputChannel){
//      currentOutputChannel=channelNum; // ??
      cMessages[cMessagesLength++]=0;
      cMessages[cMessagesLength++]=CTRL_NEW_CONNECTION;
      cMessages[cMessagesLength++]=(byte)channelNum;
//    }
    int messageStart=0;
    int messageLength=cMessagesLength;
    int nextDest=messageStart;
    for(int i=0; i<cMessagesLength; i++){
      data[nextDest++]=cMessages[i];
    }

    try {
      proxyOut.write(data, messageStart, messageLength);
    } catch (IOException e) {
      //System.out.println("proxyputByte: "+e);
    }
  }
}
