/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class PixelCache{
  private static final int SIZE=7;

  int[] buffer=new int[SIZE];
  int used=0;

  PixelCache(){}

  int getSize(){ return used; }

  boolean lookup(int value, int[] index){
    for(int i=0; i<used; i++){
      if(value==buffer[i]){
	index[0]=i;
	if(i>0){
	  int target=(i>>1);
	  do{
	    buffer[i]=buffer[i-1];
	    i--;
	  }
	  while(i>target);
	  buffer[target]=value;
	}
	return true;
      }
    }
    insert(value);
    return false;
  }

  int get(int index){
    int result=buffer[index];
    if(index>0){
      int i=index;
      int target=(i>>1);
      do{
	buffer[i]=buffer[i-1];
	i--;
      }
      while(i>target);
      buffer[target]=result;
    }
    return result;
  }

  void insert(int value){
    int insertionPoint;
    if(2>=used) insertionPoint = used;
    else insertionPoint = 2;
    int foo;
    if(used>= SIZE) foo=SIZE-1;
    else{
      foo=used;
      used++;
    }
    for(int k=foo; k>insertionPoint; k--){
      buffer[k]=buffer[k-1];
    }
    buffer[insertionPoint] = value;
  }
}
