/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class LastPixels{
  private int index=0;
  private int[] buffer=null;

  LastPixels(int num){
    buffer=new int[num];
    reset();
  }

  void add(int value){
    buffer[index++]=value;
    if(index==buffer.length) index=0;
  }

  int getValue(){
    int sum = 0;
    int i;
    for(i=index; i<buffer.length; i++){
      sum<<=1;
      sum+=buffer[i];
    }
    for(i=0; i<index; i++){
      sum<<=1;
      sum+=buffer[i];
    }
    return sum;
  }
  void reset(){
    for(int i=0; i<buffer.length; i++){ 
      buffer[i]=0;
    }
  }
}
