/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class IntCache{

  private int[] buffer=null;
  private int length=0;
  private int lastValueInserted=0;

  private int lastDiff=0;
  private int predictedBlockSize=0;

  IntCache(int size){
    buffer=new int[size];
  }

  int getSize(){ return length; }

  boolean lookup(int[] value, int[] index, int mask, boolean[] sameDiff){
    for(int i = 0; i<length; i++){
      if(value[0]==buffer[i]){
	index[0]=i;
	if(i>0){
	  int target=(i>>1);
	  do{
	    buffer[i]=buffer[i-1];
	    i--;
	  }
	  while(i>target);
	  buffer[target]=value[0];
	}
	return true;
      }
    }
    int insertionPoint;
    if(2>=length) insertionPoint=length;
    else insertionPoint = 2;
    int start;
    if(length >= buffer.length) start = buffer.length-1;
    else{
      start=length;
      length++;
    }
    for(int k=start; k>insertionPoint; k--){
      buffer[k]=buffer[k-1];
    }
    buffer[insertionPoint]=value[0];
    int diff=value[0]-lastValueInserted;

    lastValueInserted=(value[0]&mask);
    value[0]=(diff&mask);
    sameDiff[0]=(value[0]==lastDiff);
    if(!sameDiff[0]){
      lastDiff=value[0];
      int lastChangeIndex=0;
      int lastBitIsOne=(lastDiff&0x1);
      int j=1;
      for(int nextMask = 0x2; (nextMask & mask)!=0; nextMask<<=1){
	int nextBitIsOne=(lastDiff&nextMask);
	if(nextBitIsOne!=0){
	  if(lastBitIsOne==0){
	    lastChangeIndex=j;
	    lastBitIsOne=nextBitIsOne;
	  }
	}
	else{
	  if(lastBitIsOne!=0){
	    lastChangeIndex=j;
	    lastBitIsOne=nextBitIsOne;
	  }
	}
	j++;
      }
      predictedBlockSize=lastChangeIndex+1;
      if(predictedBlockSize<2)
	predictedBlockSize=2;
    }
    return false;
  }
  int get(int index){
    int result=buffer[index];
    if(index!=0){
      int i=index;
      int target=(i>>1);
      do {
	buffer[i]=buffer[i-1];
	i--;
      }
      while(i>target);
      buffer[target]=result;
    }
    return result;
  }
  void insert(int[] value, int mask){
    int insertionPoint;
    if(2>=length) insertionPoint=length;
    else insertionPoint=2;
    int start;
    if(length>=buffer.length) start=buffer.length-1;
    else{
      start=length;
      length++;
    }
    for(int k=start; k>insertionPoint; k--){
      buffer[k]=buffer[k-1];
    }
    if(lastDiff!=value[0]){
      lastDiff=value[0];
      int lastChangeIndex=0;
      int lastBitIsOne=(lastDiff&0x1);
      int j=1;
      for(int nextMask = 0x2; (nextMask & mask)!=0; nextMask <<= 1){
	int nextBitIsOne=(lastDiff&nextMask);
	if(nextBitIsOne!=0){
	  if(lastBitIsOne==0){
	    lastChangeIndex = j;
	    lastBitIsOne = nextBitIsOne;
	  }
	}
	else{
	  if(lastBitIsOne!=0){
	    lastChangeIndex = j;
	    lastBitIsOne = nextBitIsOne;
	  }
	}
	j++;
      }
      predictedBlockSize=lastChangeIndex+1;
      if(predictedBlockSize<2)
	predictedBlockSize=2;
    }
    lastValueInserted+=value[0];
    lastValueInserted&=mask;
    buffer[insertionPoint]=lastValueInserted;
    value[0]=lastValueInserted;
  }
  int getLastDiff(int mask){
    //mask=0;
    return lastDiff;
  }
  int getBlockSize(int max){
    //max=0;
    return predictedBlockSize;
  }
}
