/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class DecodeBuffer{
  int[] tmp=new int[1];
  byte[] buffer;
  int nextSrc;
  int srcMask;
  int end;

  DecodeBuffer(byte[] data, int start, int length){
    reset(data, start, length);
  }

  void reset(byte[] data, int start, int length){
    buffer=data;
    nextSrc=start;
    end=start+length;
    srcMask=0x80;
  }

  boolean decodeValue(int[] value, int numBits){
    return decodeValue(value, numBits, 0, false);
  }
  boolean decodeValue(int[] value, int numBits, int blockSize){
    return decodeValue(value, numBits, blockSize, false);
  }

  boolean decodeValue(int[] value, int numBits, int blockSize, boolean endOkay){
    int result = 0;
    int destMask = 0x1;
    int bitsRead = 0;
    if(blockSize==0) blockSize=numBits;
    byte nextSrcChar = buffer[nextSrc];
    int numBlocks = 1;
    do{
      if (numBlocks == 4) blockSize = numBits;
      int bitsToRead = ((blockSize > numBits - bitsRead) ?
			numBits - bitsRead : blockSize);
      int count = 0;
      byte lastBit;
      do{
	if(nextSrc>=end){
	  if(!endOkay){
//	    System.err.println("assertion 1 failed in DecodeBuffer.decodeValue()");
//	    System.err.println("  nextSrc="+nextSrc+", end="+end);
//	    System.exit(-1);
	  }
	  return false;
	}
	lastBit = (byte)(nextSrcChar & srcMask);
	if (lastBit!=0) result |= destMask;
	srcMask>>=1;
	if(srcMask==0){
	  srcMask=0x80;
	  nextSrc++;
	  nextSrcChar=buffer[nextSrc];
	}
	destMask<<=1;
      }
      while (bitsToRead > ++count);
      bitsRead += bitsToRead;
      if(bitsRead<numBits){
	if(nextSrc>=end){
	  if (!endOkay){
//	    System.err.println("assertion 2 failed in DecodeBuffer.decodeValue()");
//	    System.err.println("  nextSrc="+nextSrc+", end="+end);
//	    System.exit(-1);
	  }
	  return false;
	}
	byte moreData = (byte)(nextSrcChar & srcMask);
	srcMask>>=1;
	if(srcMask==0){
	  srcMask=0x80;
	  nextSrc++;
	  nextSrcChar = buffer[nextSrc];
	}
	if(moreData==0){
	  if(lastBit!=0){
	    do{
	      result |= destMask;
	      destMask <<= 1;
	    }
	    while (numBits > ++bitsRead);
	  }
	  else{
	    bitsRead = numBits;
	  }
	}
      }
      blockSize>>=1;
      if(blockSize<2) blockSize=2;
      numBlocks++;
    }
    while (numBits > bitsRead);
    value[0] = result;
    return true;
  }

  boolean decodeCachedValue(int[] value, int numBits, IntCache cache){
    return decodeCachedValue(value, numBits, cache, 0, false);
  }
  boolean decodeCachedValue(int[] value, int numBits, IntCache cache, int blockSize){
    return decodeCachedValue(value, numBits, cache, blockSize, false);
  }
  boolean decodeCachedValue(int[] value, int numBits, IntCache cache, 
			int blockSize, boolean endOkay){
    if(nextSrc>=end) return false;
    int index = 0;
    byte nextSrcChar = buffer[nextSrc];

    while((nextSrcChar & srcMask)==0){
      index++;
      srcMask>>=1;
      if(srcMask== 0){
	srcMask=0x80;
	nextSrc++;
	if(nextSrc >= end){
	  if (!endOkay){
//	    System.err.println("assertion 1 failed in DecodeBuffer.decodeCachedValue()");
//	    System.err.println("  nextSrc="+nextSrc+", end="+end);
//	    System.exit(-1);
	  }
	  return false;
	}
	nextSrcChar = buffer[nextSrc];
      }
    }
    srcMask>>=1;
    if(srcMask==0){
      srcMask=0x80;
      nextSrc++;
    }

    if (index == 2){
      decodeValue(tmp, 1);
      if(tmp[0]!=0){
	value[0]=cache.getLastDiff(Constants.PARTIAL_INT_MASK[numBits]);
	cache.insert(value, Constants.PARTIAL_INT_MASK[numBits]);
      }
      else{
	blockSize = cache.getBlockSize(numBits);
	if (decodeValue(value, numBits, blockSize, endOkay)){
	  cache.insert(value, Constants.PARTIAL_INT_MASK[numBits]);
	  return true;
	}
      }
      return false;
    }
    else{
      if(index>2) index--;
      if (index>cache.getSize()){
//      System.err.println("assertion 2 failed in DecodeBuffer.decodeCachedValue()");
//      System.err.println("  index="+index+", cache.getSize()="+cache.getSize());
//	System.exit(-1);
      }
      value[0] = cache.get(index);
      return true;
    }
  }
  boolean decodeCachedValue(byte[] value, int numBits, CharCache cache){
    return decodeCachedValue(value, numBits, cache, 0, false);
  }
  boolean decodeCachedValue(byte[] value, int numBits, CharCache cache, int blockSize){
    return decodeCachedValue(value, numBits, cache, blockSize, false);
  }
  boolean decodeCachedValue(byte[] value, int numBits, CharCache cache,
			    int blockSize, boolean endOkay){
    if(nextSrc>=end){
      return false;
    }
    int index = 0;
    byte nextSrcChar = buffer[nextSrc];
    while ((nextSrcChar & srcMask)==0){
      index++;
      srcMask>>=1;
      if(srcMask==0){
	srcMask=0x80;
	nextSrc++;
	if (nextSrc>=end){
	  if (!endOkay){
//	    System.err.println("assertion 3 failed in DecodeBuffer.decodeCachedValue()");
//	    System.err.println("  nextSrc="+nextSrc+", end="+end);
//	    System.exit(-1);
	  }
	  return false;
	}
	nextSrcChar = buffer[nextSrc];
      }
    }
    srcMask >>= 1;
    if(srcMask==0){
      srcMask=0x80;
      nextSrc++;
    }
    if (index == 2){
      if(decodeValue(tmp, numBits, blockSize, endOkay)){
	value[0]=(byte)tmp[0];
	cache.insert(value[0]);
	return true;
      }
      else{
	return false;
      }
    }
    else{
      if(index>2) index--;
      if(index>cache.getSize()){
//      System.err.println("assertion 4 failed in DecodeBuffer.decodeCachedValue()");
//      System.err.println("  index="+index+", cache.getSize()="+cache.getSize());
//	System.exit(-1);
      }
      value[0]=(byte)cache.get(index);
      return true;
    }
  }

  boolean decodeCachedValue(int[] value, int numBits, PixelCache cache,
			    HuffmanCoder escapeCoder0,
			    HuffmanCoder escapeCoder1){
    return decodeCachedValue(value, numBits, cache,
			     escapeCoder0,
			     escapeCoder1,
			     false);
  }
  
  boolean decodeCachedValue(int[] value, int numBits, PixelCache cache,
			HuffmanCoder escapeCoder0,
			HuffmanCoder escapeCoder1, 
			boolean endOkay){
    if(nextSrc>=end) return false;
    int index=0;
    byte nextSrcChar=buffer[nextSrc];
    while((nextSrcChar&srcMask)==0){
      index++;
      srcMask>>=1;
      if(srcMask==0){
	srcMask=0x80;
	nextSrc++;
	if(nextSrc >= end){
	  if(!endOkay){
//	    System.err.println("assertion 5 failed in DecodeBuffer.decodeCachedValue()");
//	    System.err.println("  nextSrc="+nextSrc+", end="+end);
//	    System.exit(-1);
	  }
	  return false;
	}
	nextSrcChar=buffer[nextSrc];
      }
    }
    srcMask>>=1;
    if(srcMask==0){
      srcMask=0x80;
      nextSrc++;
    }
    if(index==2){
      value[0]=0;
      int[] pixelValue=new int[1];
      if(!decodeValue(pixelValue, 1, 1, endOkay)) return false;
      int mask=0x1;
      for(int x=0; x<numBits;){
	int runLength;
	if (pixelValue[0]!=0){
	  runLength=escapeCoder1.decode(this)+1;
	  for(int i=runLength; i>0; i--){
	    value[0]|=mask;
	    mask<<=1;
	  }
	  pixelValue[0]=0;
	}
	else{
	  runLength=escapeCoder0.decode(this) + 1;
	  mask<<=runLength;
	  pixelValue[0]=1;
	}
	x+=runLength;
      }
      cache.insert(value[0]);
      return true;
    }
    else{
      if(index>2)index--;
      if(index>cache.getSize()){
//      System.err.println("assertion 6 failed in DecodeBuffer.decodeCachedValue()");
//      System.err.println("  index="+index+", cache.getSize()="+cache.getSize());
//      System.exit(-1);
      }
      value[0]=cache.get(index);
      return true;
    }
  }
}
