/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

import java.io.*;
import java.net.*;
import java.lang.*;

class ClientProxy extends Proxy{
  private foo xfoo;

  ClientProxy() throws IOException{
    xfoo= new foo(this);
  }
  ClientProxy(String host) throws IOException{
    super(host);
    xfoo = new foo(this);
  }
  ClientProxy(int port) throws IOException{
    super(port);
    xfoo = new foo(this);
  }
  ClientProxy(int port, int xport) throws IOException{
    super(port);
    xfoo = new foo(this, xport);
  }
  ClientProxy(String host, int xport, int port) throws IOException{
    super(host, port);
    xfoo = new foo(this, xport);
  }
  ClientProxy(String host, int xport) throws IOException{
    super(host);
    xfoo = new foo(this, xport);
  }
  ClientProxy(ServerSocket ss){
    super(ss);
    xfoo = new foo(this);
  }
  Channel createChannel(){
    Channel foo=new ClientChannel();
    foo.setProxy(this); 
    return foo;
  }

  public void run () {
    super.run ();
    // stop foo x-server
    xfoo.stopit ();
  }

  public static void main(String[] arg){
    ClientProxy cp;
    try{
      if (arg.length == 3) {
	  //format: host xport dxpcport
        int xport = Integer.parseInt (arg[1]);
	int dxpcport = Integer.parseInt (arg[2]);
	cp = new ClientProxy (arg[0], xport, dxpcport);
      }
      else if (arg.length == 2){
        //format: host xport
	int xport = Integer.parseInt (arg[1]);
	cp = new ClientProxy (arg[0], xport);
      }
      else if (arg.length == 1){
        cp = new ClientProxy (arg[0]);
      }
      else{
	cp = new ClientProxy ();
      }
    }
    catch (IOException e){
      System.err.println ("cannot connect");
      return;
    }
    cp.start ();
  }

  class foo extends Thread{
    ServerSocket server;
    Proxy proxy;
    boolean running;
    int port;

    foo(Proxy proxy){
      this (proxy, 6008);
    }
    foo (Proxy proxy, int xport){
      try{
	server = new ServerSocket (xport);
      }
      catch (Exception e){}
      running = true;
      port = xport;
      this.proxy = proxy;
      this.start ();
    }
    public void run () {
      byte[] buff = new byte[3];
      while (true){
        try{
          Socket socket = server.accept ();
	  if (!running)
	    break;
	  Channel channel = createChannel ();
	  channel.setSocket (socket);
	  proxy.add ((Channel) channel);
	  proxy.proxyNew (channel.getId (), buff);
	  channel.start ();
	}
	catch (Exception e){ }
      }
      // delete channels
      System.err.println ("1");
      System.err.println ("2");
    }

    public void stopit () {
      running = false;
      try {
        Socket s = new Socket ("localhost", port);
	s.close ();
	server.close ();
      }
      catch (Exception e){
        System.err.println ("cannot close server");
      }
    }
  }
}
