/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class ClientCache{
  static final int PUT_IMAGE_PIXEL_CACHE_SIZE = 251;
  static final int CLIENT_TEXT_CACHE_SIZE = 9999;
  static final int FILL_POLY_MAX_POINTS = 10;

  static final int SD_VERTICAL_0=0;
  static final int SD_VERTICAL_PLUS_1=1;
  static final int SD_VERTICAL_MINUS_1=2;
  static final int SD_HORIZONTAL=3;
  static final int SD_PASS=4;
  static final int SD_VERTICAL_MINUS_2=5;
  static final int SD_VERTICAL_PLUS_2=6;
  static final int SD_NUM_CODES=7;

  CharCache[] textCache=new CharCache[CLIENT_TEXT_CACHE_SIZE];
  IntCache cursorCache=new IntCache(16);
  IntCache gcCache=new IntCache(16);
  IntCache drawableCache=new IntCache(16);
  IntCache windowCache=new IntCache(16);
  IntCache colormapCache=new IntCache(16);
  IntCache visualCache=new IntCache(16);
  CharCache depthCache=new CharCache();
  int lastFont=0;
  int lastRequestSequenceNum=0;

  // Opcode prediction caches (predict next opcode based on previous one)
  CharCache[] opcodeCache=new CharCache[256];
  int lastOpcode=0;

  // AllocColor request
  IntCache[] allocColorRGBCache=new IntCache[3];

  // ChangeProperty request
  CharCache changePropertyFormatCache=new CharCache();
  IntCache changePropertyPropertyCache=new IntCache(16);
  IntCache changePropertyTypeCache=new IntCache(16);
  IntCache changePropertyData32Cache=new IntCache(16);
  TextCompressor changePropertyTextCompressor=new TextCompressor(textCache);

  // ClearArea request
  IntCache[] clearAreaGeomCache=new IntCache[4];

  // ConfigureWindow request
  IntCache configureWindowBitmaskCache=new IntCache(4);
  IntCache[] configureWindowAttrCache=new IntCache[7];

  // ConvertSelection request
  IntCache convertSelectionRequestorCache=new IntCache(16);
  IntCache[] convertSelectionAtomCache=new IntCache[3];
  int convertSelectionLastTimestamp=0;

  // CopyArea request
  IntCache[] copyAreaGeomCache=new IntCache[6];

  // CopyPlane request
  IntCache[] copyPlaneGeomCache=new IntCache[6];
  IntCache copyPlaneBitPlaneCache=new IntCache(8);

  // CreateGC request
  IntCache createGCBitmaskCache=new IntCache(8);
  IntCache[] createGCAttrCache=new IntCache[24];

  // CreatePixmap request
  int createPixmapLastPixmap=0;
  IntCache createPixmapXCache=new IntCache(8);
  IntCache createPixmapYCache=new IntCache(8);

  // CreateWindow request
  IntCache[] createWindowGeomCache=new IntCache[6];
  IntCache createWindowBitmaskCache=new IntCache(8);
  IntCache[] createWindowAttrCache=new IntCache[15];

  // FillPoly request
  IntCache fillPolyNumPointsCache=new IntCache(8);
  IntCache[] fillPolyXRelCache=new IntCache[FILL_POLY_MAX_POINTS];
  IntCache[] fillPolyXAbsCache=new IntCache[FILL_POLY_MAX_POINTS];
  IntCache[] fillPolyYRelCache=new IntCache[FILL_POLY_MAX_POINTS];
  IntCache[] fillPolyYAbsCache=new IntCache[FILL_POLY_MAX_POINTS];
  int[] fillPolyRecentX=new int[8];
  int[] fillPolyRecentY=new int[8];
  int fillPolyIndex=0;

  // GetSelectionOwner request
  IntCache getSelectionOwnerSelectionCache=new IntCache(8);

  // GrabButton request
  // (also used for GrabPointer)
  IntCache grabButtonEventMaskCache=new IntCache(8);
  IntCache grabButtonConfineCache=new IntCache(8);
  CharCache grabButtonButtonCache=new CharCache();
  IntCache grabButtonModifierCache=new IntCache(8);

  // GrabKeyboard request
  int grabKeyboardLastTimestamp=0;

  // ImageText8 request
  int imageText8LastX=0;
  int imageText8LastY=0;
  IntCache imageText8CacheX=new IntCache(8);
  IntCache imageText8CacheY=new IntCache(8);
  TextCompressor imageText8TextCompressor=new TextCompressor(textCache);

  // InternAtom request
  TextCompressor internAtomTextCompressor=new TextCompressor(textCache);

  // OpenFont request
  TextCompressor openFontTextCompressor=new TextCompressor(textCache);

  // PolyFillRectangle request
  IntCache[] polyFillRectangleCacheX=new IntCache[2];
  IntCache[] polyFillRectangleCacheY=new IntCache[2];
  IntCache[] polyFillRectangleCacheWidth=new IntCache[2];
  IntCache[] polyFillRectangleCacheHeight=new IntCache[2];

  // PolyLine request
  IntCache[] polyLineCacheX=new IntCache[2];
  IntCache[] polyLineCacheY=new IntCache[2];

  // PolyPoint request
  IntCache[] polyPointCacheX=new IntCache[2];
  IntCache[] polyPointCacheY=new IntCache[2];

  // PolyRectangle request
  IntCache[] polyRectangleGeomCache=new IntCache[4];

  // PolySegment request
  IntCache polySegmentCacheX=new IntCache(8);
  IntCache polySegmentCacheY=new IntCache(8);
  int[] polySegmentLastX=new int[2];
  int[] polySegmentLastY=new int[2];
  int polySegmentCacheIndex=0;

  // PolyText8 request
  int polyText8LastX=0;
  int polyText8LastY=0;
  IntCache polyText8CacheX=new IntCache(8);
  IntCache polyText8CacheY=new IntCache(8);
  IntCache polyText8FontCache=new IntCache(8);
  CharCache polyText8DeltaCache=new CharCache();
  TextCompressor polyText8TextCompressor=new TextCompressor(textCache);

  // PutImage request
  IntCache putImageWidthCache=new IntCache(8);
  IntCache putImageHeightCache=new IntCache(8);
  int putImageLastX=0;
  int putImageLastY=0;
  IntCache putImageXCache=new IntCache(8);
  IntCache putImageYCache=new IntCache(8);
  CharCache putImageOffsetCache=new CharCache();
  HuffmanCoder putImagePixel0Coder=new HuffmanCoder(PIXEL_COUNT_0,
						    PixelHistogram0,
						    PIXEL_OVERFLOW_COUNT_0);
  HuffmanCoder putImagePixel1Coder=new HuffmanCoder(PIXEL_COUNT_1,
						    PixelHistogram1,
						    PIXEL_OVERFLOW_COUNT_1);
  HuffmanCoder putImageDiffCoder=new HuffmanCoder(SD_NUM_CODES, ScanLineDiffCodes);
  PixelCache[] putImagePixelCache=new PixelCache[PUT_IMAGE_PIXEL_CACHE_SIZE];
  LastPixels putImageLastPixels=new LastPixels(3);
  HuffmanCoder columnPixel0Coder=new HuffmanCoder(COLUMN_PIXEL_COUNT_0, 
						  ColumnPixelHistogram0,
						  0);
  HuffmanCoder columnPixel1Coder=new HuffmanCoder(COLUMN_PIXEL_COUNT_1, 
						  ColumnPixelHistogram1,
						  0);
  int[] putImageReferenceLine=null;
  int[] putImageCodingLine=null;
  int putImageLineSize=0;
  CharCache putImageByteCache=new CharCache();

  // QueryColors request
  int queryColorsLastPixel=0;

  // SetClipRectangles request
  IntCache setClipRectanglesXCache=new IntCache(8);
  IntCache setClipRectanglesYCache=new IntCache(8);
  IntCache[] setClipRectanglesGeomCache=new IntCache[4];

  // SetDashes request
  IntCache setDashesLengthCache=new IntCache(8);
  IntCache setDashesOffsetCache=new IntCache(8);
  CharCache[] setDashesDashCache=new CharCache[2];

  // SetSelectionOwner request
  IntCache setSelectionOwnerCache=new IntCache(8);
  IntCache setSelectionOwnerTimestampCache=new IntCache(8);

  // TranslateCoords request
  IntCache translateCoordsSrcCache=new IntCache(8);
  IntCache translateCoordsDestCache=new IntCache(8);
  IntCache translateCoordsXCache=new IntCache(8);
  IntCache translateCoordsYCache=new IntCache(8);

  static final int PIXEL_COUNT_0 = 63;
  static final int[] PixelHistogram0 =
{
  82551,
  69015,
  30616,
  24739,
  15491,
  10108,
  7422,
  7569,
  3408,
  3457,
  2013,
  2144,
  3527,
  3187,
  2883,
  1717,
  1487,
  1024,
  789,
  618,
  993,
  1029,
  664,
  711,
  667,
  736,
  572,
  492,
  909,
  432,
  422,
  306,
  269,
  265,
  522,
  445,
  249,
  210,
  252,
  150,
  189,
  181,
  253,
  217,
  251,
  272,
  183,
  231,
  198,
  186,
  177,
  196,
  134,
  287,
  190,
  327,
  150,
  155,
  119,
  138,
  230,
  262,
  0
};
  static final int PIXEL_OVERFLOW_COUNT_0 = 15400;

  static final int PIXEL_COUNT_1 = 32;
  static final int[] PixelHistogram1 =
{
  181385,
  57253,
  51214,
  19913,
  14296,
  8104,
  3138,
  1706,
  1985,
  1244,
  1011,
  581,
  869,
  327,
  456,
  397,
  661,
  191,
  198,
  155,
  95,
  76,
  28,
  18,
  10,
  3,
  3,
  11,
  2,
  0,
  6,
  2
};
  static final int PIXEL_OVERFLOW_COUNT_1 = 4;

  static final int COLUMN_PIXEL_COUNT_0 = 32;
  static final int[] ColumnPixelHistogram0 =
{
  4646,
  5347,
  7237,
  10526,
  11306,
  4105,
  2643,
  1766,
  6663,
  3805,
  2908,
  1225,
  502,
  1161,
  758,
  363,
  186,
  75,
  61,
  513,
  120,
  4,
  21,
  4,
  0,
  0,
  29,
  1,
  0,
  0,
  0,
  0
};

  static final int COLUMN_PIXEL_COUNT_1 = 32;
  static final int[] ColumnPixelHistogram1 =
{
  20339,
  8153,
  4903,
  2193,
  933,
  310,
  1024,
  402,
  486,
  645,
  598,
  132,
  162,
  92,
  35,
  5,
  3,
  7,
  10,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
};


// Precomputed static prefix code for encoding of run length deltas
// between scan lines...based on Group 4 FAX encoding.  (Reference:
// "FAX: Digital Facsimile Technology and Applications," 2nd Edition;
// McConnel, Bodson, and Schaphorst; Artech House, 1992; ISBN 0-89006-495-4)
  static final byte[][] ScanLineDiffCodes =
{
       "0".getBytes(),			// Vertical +0
     "100".getBytes(),			// Vertical +1
     "110".getBytes(),			// Vertical -1
     "101".getBytes(),			// Horizontal
    "1111".getBytes(),			// Pass
   "11100".getBytes(),			// Vertical +2
   "11101".getBytes(),			// Vertical -2
};

  ClientCache(){
    for(int i=0; i<3; i++){
      allocColorRGBCache[i]=new IntCache(8);
      convertSelectionAtomCache[i]=new IntCache(8);
    }
    for(int i=0; i<4; i++)
      clearAreaGeomCache[i]=new IntCache(8);
    for(int i=0; i<7; i++)
      configureWindowAttrCache[i]=new IntCache(8);
    for(int i=0; i<6; i++){
      copyAreaGeomCache[i]=new IntCache(8);
      copyPlaneGeomCache[i]=new IntCache(8);
    }
    for(int i=0; i<23; i++){
      createGCAttrCache[i]=new IntCache(Constants.CREATEGC_FIELD_WIDTH[i]);
    }
    for(int i=0; i<6; i++){
      createWindowGeomCache[i]=new IntCache(8);
    }
    for(int i=0; i<15; i++){
      createWindowAttrCache[i]=new IntCache(8);
    }
    for(int i=0; i<FILL_POLY_MAX_POINTS; i++){
      fillPolyXRelCache[i]=new IntCache(8);
      fillPolyXAbsCache[i]=new IntCache(8);
      fillPolyYRelCache[i]=new IntCache(8);
      fillPolyYAbsCache[i]=new IntCache(8);
    }
    for(int i=0; i<8; i++){
      fillPolyRecentX[i]=0;
      fillPolyRecentY[i]=0;
    }
    for(int i=0; i<2; i++){
      polyFillRectangleCacheX[i]=new IntCache(8);
      polyFillRectangleCacheY[i]=new IntCache(8);
      polyFillRectangleCacheWidth[i]=new IntCache(8);
      polyFillRectangleCacheHeight[i]=new IntCache(8);
    }
    for(int i=0; i<2; i++){
      polyLineCacheX[i]=new IntCache(8);
      polyLineCacheY[i]=new IntCache(8);
    }
    for(int i=0; i<2; i++){
      polyPointCacheX[i]=new IntCache(8);
      polyPointCacheY[i]=new IntCache(8);
    }
    for(int i=0; i<4; i++)
      polyRectangleGeomCache[i]=new IntCache(8);
    for(int i=0; i<2; i++){
      polySegmentLastX[i]=0;
      polySegmentLastY[i]=0;
    }
    for(int i=0; i<4; i++){
      setClipRectanglesGeomCache[i]=new IntCache(8);
    }
    for(int i=0; i<textCache.length; i++){
      textCache[i]=new CharCache();
    }
    for(int i=0; i<opcodeCache.length; i++){
      opcodeCache[i]=new CharCache();
    }
    for(int i=0; i<putImagePixelCache.length; i++){
      putImagePixelCache[i]=new PixelCache();
    }
    for(int i=0; i<setDashesDashCache.length; i++){
      setDashesDashCache[i]=new CharCache();
    }
  }
}
