/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class BlockCacheSet{
  private BlockCache[] caches;
  int used=0;

  BlockCacheSet(int numCaches){
    caches=new BlockCache[numCaches];
    for(int i=0;i<caches.length;i++){
      caches[i]=new BlockCache();
    }
  }

  boolean lookup(int start, int length, byte[] data, int[] index){
    int checksum = BlockCache.checksum(start, length, data);
    for (int i=0; i<used; i++){
      if((caches[i].getChecksum()==checksum) &&
	 (caches[i].compare(start, length, data, false))){
	index[0]=i;
	if(i>0){
	  BlockCache save=caches[i];
	  int target=(i>>1);
	  do{
	    caches[i]=caches[i-1];
	    i--;
	  }
	  while(i>target);
	  caches[target]=save;
	}
	return true;
      }
    }
    set(start, length, data);
    return false;
  }

  void get(int index, int[] size, byte[][] data){
    size[0]=caches[index].getLength();
    data[0]=caches[index].getData();
    if(index>0){
      BlockCache save=caches[index];
      int target=(index>>1);
      do{
	caches[index]=caches[index-1];
	index--;
      }
      while(index>target);
      caches[target]=save;
    }
  }

  void set(int start, int length, byte[] data){
    int insertionPoint=(used>>1);
    int foo;
    if(used>=caches.length) foo=caches.length-1;
    else{
      foo=used;
      used++;
    }
    BlockCache save=caches[foo];
    for(int k = foo; k>insertionPoint; k--){
      caches[k]=caches[k-1];
    }
    caches[insertionPoint]=save;
    save.set(start, length, data);
  }
}
