/* JDxpc -- DXPC in pure Java
 *
 *  Copyright (C) 2000 ymnk, JCraft, Inc.
 *
 *  Many thanks to 
 *    Brian Pane<brianp@cnet.com> and
 *    Zachary Vonler<lightborn@mail.utexas.edu>.
 *  JDxpc has been based on their awesome works, dxpc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jdxpc;

class BlockCache{
  private byte[] buffer=new byte[1];
  private int length=1;
  private int checksum=0;

  BlockCache(){}

  boolean compare(int start, int length, byte[] data){
    return compare(start, length, data, true);
  }

  boolean compare(int start, int length, byte[] data, boolean overwrite){
    boolean match=false;
    if(this.length==length){
      match=true;
      for(int i=0, j=start, k=0; k<length; i++, j++, k++){
	if(data[j]!=buffer[i]){
	  match=false;
	  break;
	}
      }
    }
    if(!match && overwrite){
      set(start, length, data);
    }
    return match;
  }

  void set(int start, int length, byte[] data){
    if(buffer.length<length){
      byte[] foo=new byte[length];
      //System.arraycopy(buffer, 0, foo, 0, this.start);
      buffer=foo;
    }
    this.length=length;
    System.arraycopy(data, start, buffer, 0, length);
    checksum=checksum(start, length, data);
  }

  static int checksum(int start, int length, byte[] data){
    int sum=0;
    int shift=0;
    int next=start;
    for(int i=0; i<length; i++){
      int value = data[next++]&0xff;
      sum+=(value<<shift);
      shift++;
      if(shift==8) shift=0;
    }
    return sum;
  }
  int getChecksum(){return checksum;}
  int getLength(){return length;}
  byte[] getData(){return buffer;}
}
